/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Instance_Generation.MSE;

import java.util.Arrays;
import java.util.LinkedList;
import keel.Algorithms.Instance_Generation.Basic.Prototype;
import keel.Algorithms.Instance_Generation.Basic.PrototypeGenerationAlgorithm;
import keel.Algorithms.Instance_Generation.Basic.PrototypeGenerator;
import keel.Algorithms.Instance_Generation.Basic.PrototypeSet;
import keel.Algorithms.Instance_Generation.utilities.Distance;
import keel.Algorithms.Instance_Generation.utilities.KNN.KNN;
import keel.Algorithms.Instance_Generation.utilities.Parameters;

public class MSEGenerator
extends PrototypeGenerator {
    private int k;
    private int numberOfInitialCentroids;
    private double GradientStep;
    private double Temperature;
    protected int numberOfPrototypes;
    protected int numberOfClass;

    public MSEGenerator(PrototypeSet _trainingDataSet, int k, int centroid, double gradStep, double temp) {
        super(_trainingDataSet);
        this.algorithmName = "MSE";
        this.k = k;
        this.numberOfInitialCentroids = centroid;
        this.GradientStep = gradStep;
        this.Temperature = temp;
    }

    public MSEGenerator(PrototypeSet t, Parameters parameters) {
        super(t, parameters);
        this.algorithmName = "MSE";
        this.k = parameters.getNextAsInt();
        this.numberOfInitialCentroids = parameters.getNextAsInt();
        this.GradientStep = parameters.getNextAsDouble();
        this.Temperature = parameters.getNextAsDouble();
        this.numberOfClass = this.trainingDataSet.getPosibleValuesOfOutput().size();
        System.out.println("Isaac dice: k= " + this.k + " cent = " + this.numberOfInitialCentroids + " gs= " + this.GradientStep + " t =" + this.Temperature);
        System.out.println("Number of class= " + this.numberOfClass);
    }

    protected double probabilityBelongCluster(Prototype x, PrototypeSet conjunto, int index) {
        double dist = 0.0;
        double denominator = 0.0;
        for (Prototype p : conjunto) {
            dist = Distance.d(x, p);
            denominator += Math.exp(-dist / this.Temperature);
        }
        dist = Distance.d(x, (Prototype)conjunto.get(index));
        double numerator = Math.exp(-dist / this.Temperature);
        return numerator / denominator;
    }

    protected double desiredProbabilities(Prototype x, PrototypeSet conjunto, int index) {
        double output = 0.0;
        double dist = 0.0;
        double denominator = 0.0;
        if (x.getOutput(0) != ((Prototype)conjunto.get(index)).getOutput(0)) {
            output = 0.0;
        } else {
            for (Prototype p : conjunto) {
                if (x.getOutput(0) != p.getOutput(0)) continue;
                dist = Distance.d(x, p);
                denominator += Math.exp(-dist / this.Temperature);
            }
            dist = Distance.d(x, (Prototype)conjunto.get(index));
            double numerator = Math.exp(-dist / this.Temperature);
            output = numerator / denominator;
        }
        return output;
    }

    protected double costFunction(Prototype X, PrototypeSet conjunto) {
        double coste = 0.0;
        for (int i = 0; i < conjunto.size(); ++i) {
            double term1 = this.desiredProbabilities(X, conjunto, i);
            double term2 = this.probabilityBelongCluster(X, conjunto, i);
            coste += (term1 - term2) * (term1 - term2);
        }
        coste = coste * 0.5 * this.Temperature;
        return coste;
    }

    protected void modifyLocation(Prototype X, PrototypeSet vectors, Prototype[] lastIncrements, int index) {
        double gradient = 0.0;
        double sumatory = 0.0;
        double sigmaij = 0.0;
        PrototypeSet tData = this.trainingDataSet;
        Prototype diference = X.sub((Prototype)vectors.get(index));
        diference = diference.mul(this.probabilityBelongCluster(X, vectors, index));
        diference = diference.mul(this.GradientStep);
        for (int j = 0; j < vectors.size(); ++j) {
            double calc = this.desiredProbabilities(X, vectors, j) - this.probabilityBelongCluster(X, vectors, j);
            sigmaij = index == j ? 1.0 : 0.0;
            sumatory += (calc *= sigmaij - this.probabilityBelongCluster(X, vectors, j));
        }
        Prototype Increment = diference.mul(sumatory);
        Prototype MuLastIncrement = lastIncrements[index].mul(0.9);
        Prototype IncrementFinal = Increment.add(MuLastIncrement);
        IncrementFinal.applyThresholds();
        ((Prototype)vectors.get(index)).set(((Prototype)vectors.get(index)).add(IncrementFinal));
        lastIncrements[index].set(IncrementFinal);
    }

    protected PrototypeSet initDataSet() {
        PrototypeSet initial = new PrototypeSet();
        LinkedList<int[]> clusters = new LinkedList<int[]>();
        for (int i = 0; i < this.numberOfClass; ++i) {
            PrototypeSet conjunto = this.trainingDataSet.getFromClass(i).clone();
            if (conjunto.size() < this.numberOfInitialCentroids) continue;
            PrototypeSet centroid = new PrototypeSet();
            double[][] conjunto2 = conjunto.prototypeSetTodouble();
            double[][] center = new double[this.numberOfInitialCentroids][conjunto2[0].length];
            int[] clusteres = centroid.Cmeans(conjunto2, this.numberOfInitialCentroids, center);
            clusters.add(clusteres);
            centroid.doubleToprototypeSet(center, i);
            initial.add(centroid);
        }
        int majority = this.k / 2 + 1;
        int[] toClean = new int[initial.size()];
        Arrays.fill(toClean, 0);
        int pos = 0;
        for (Prototype q : initial) {
            double class_q = q.getOutput(0);
            PrototypeSet neighbors = KNN.knn(q, this.trainingDataSet, this.k);
            int counter = 0;
            for (Prototype q1 : neighbors) {
                double class_q1 = q1.getOutput(0);
                if (class_q1 != class_q) continue;
                ++counter;
            }
            if (counter < majority) {
                toClean[pos] = 1;
            }
            ++pos;
        }
        PrototypeSet aux = new PrototypeSet();
        for (int i = 0; i < toClean.length; ++i) {
            if (toClean[i] != 0) continue;
            aux.add(initial.get(i));
        }
        initial = aux.clone();
        boolean[] marcas = new boolean[initial.size()];
        Arrays.fill(marcas, true);
        double accuracyInic = KNN.classficationAccuracy(initial, this.trainingDataSet);
        for (int i = 0; i < initial.size(); ++i) {
            marcas[i] = false;
            PrototypeSet leaveOneOut = initial.without((Prototype)initial.get(i));
            double accuracy = KNN.classficationAccuracy(leaveOneOut, this.trainingDataSet);
            if (!(accuracy > accuracyInic)) continue;
            marcas[i] = true;
        }
        PrototypeSet clean = new PrototypeSet();
        for (int i = 0; i < marcas.length; ++i) {
            if (marcas[i]) continue;
            clean.add(initial.get(i));
        }
        System.out.println("Initial size = " + initial.size());
        System.out.println("Clean size = " + clean.size());
        return clean;
    }

    @Override
    public PrototypeSet reduceSet() {
        System.out.print("\nThe algorithm is starting...\n Computing...\n");
        System.out.println("Number of class " + this.numberOfClass);
        PrototypeSet outputDataSet = this.initDataSet();
        System.out.println("Accuracy % " + MSEGenerator.accuracy(outputDataSet, this.trainingDataSet));
        System.out.println("Reduction % " + (100 - outputDataSet.size() * 100 / this.trainingDataSet.size()));
        int[] dsort = new int[this.trainingDataSet.size()];
        this.inic_vector(dsort);
        this.desordenar_vector(dsort);
        int it = 0;
        double error = Double.POSITIVE_INFINITY;
        double newError = 0.0;
        Prototype[] increments = new Prototype[outputDataSet.size()];
        for (int i = 0; i < increments.length; ++i) {
            increments[i] = new Prototype(((Prototype)this.trainingDataSet.get(0)).numberOfInputs(), 1);
            for (int j = 0; j < increments[i].numberOfInputs(); ++j) {
                increments[i].setInput(j, 0.0);
            }
        }
        boolean cambio = true;
        while (cambio) {
            cambio = false;
            Prototype instance = (Prototype)this.trainingDataSet.get(dsort[it % this.trainingDataSet.size()]);
            for (int i = 0; i < outputDataSet.size(); ++i) {
                this.modifyLocation(instance, outputDataSet, increments, i);
            }
            newError = this.costFunction(instance, outputDataSet);
            if (newError < error || this.GradientStep == 0.0) {
                cambio = true;
                error = newError;
            }
            ++it;
            this.GradientStep *= 0.5;
            this.Temperature = 0.9 * this.Temperature;
        }
        outputDataSet.applyThresholds();
        System.out.println("Iterations = " + it);
        System.out.println("Accuracy % " + MSEGenerator.accuracy(outputDataSet, this.trainingDataSet));
        System.out.println("Reduction % " + (100 - outputDataSet.size() * 100 / this.trainingDataSet.size()));
        boolean[] marcas = new boolean[outputDataSet.size()];
        Arrays.fill(marcas, true);
        double accuracyInic = KNN.classficationAccuracy(outputDataSet, this.trainingDataSet);
        for (int i = 0; i < outputDataSet.size(); ++i) {
            marcas[i] = false;
            PrototypeSet leaveOneOut = outputDataSet.without((Prototype)outputDataSet.get(i));
            double accuracy = KNN.classficationAccuracy(leaveOneOut, this.trainingDataSet);
            if (!(accuracy > accuracyInic)) continue;
            marcas[i] = true;
        }
        PrototypeSet clean = new PrototypeSet();
        for (int i = 0; i < marcas.length; ++i) {
            if (marcas[i]) continue;
            clean.add(outputDataSet.get(i));
        }
        System.out.println("Accuracy % " + MSEGenerator.accuracy(clean, this.trainingDataSet));
        System.out.println("Reduction % " + (100 - clean.size() * 100 / this.trainingDataSet.size()));
        return outputDataSet;
    }

    public static void main(String[] args) {
        Parameters.setUse("MSE", "<seed> <Number of neighbors>\n<Swarm size>\n<Particle Size>\n<MaxIter>\n<DistanceFunction>");
        Parameters.assertBasicArgs(args);
        PrototypeSet training = PrototypeGenerationAlgorithm.readPrototypeSet(args[0]);
        PrototypeSet test = PrototypeGenerationAlgorithm.readPrototypeSet(args[1]);
        long seed = Parameters.assertExtendedArgAsInt(args, 2, "seed", 0.0, 9.223372036854776E18);
        MSEGenerator.setSeed(seed);
        int blocks = Parameters.assertExtendedArgAsInt(args, 10, "number of blocks", 1.0, 2.147483647E9);
        MSEGenerator generator = new MSEGenerator(training, 3, 20, 0.05, 50.0);
        PrototypeSet resultingSet = generator.execute();
        int accuracy1NN = KNN.classficationAccuracy(resultingSet, test);
        generator.showResultsOfAccuracy(Parameters.getFileName(), accuracy1NN, test);
    }
}

