## ----setup, include = FALSE---------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>",
  eval = FALSE
)

## ----load-package-------------------------------------------------------------
# library(boilerplate)

## ----list-versions------------------------------------------------------------
# # See all available database files
# # Using a temporary directory for this example
# temp_version <- file.path(tempdir(), "version_example")
# boilerplate_init(data_path = temp_version, create_empty = FALSE, create_dirs = TRUE, confirm = FALSE, quiet = TRUE)
# 
# files <- boilerplate_list_files(data_path = temp_version)
# print(files)
# 
# # Check what versions exist for methods
# methods_files <- boilerplate_list_files(data_path = temp_version, category = "methods")

## ----save-with-timestamp------------------------------------------------------
# # Load your database
# db <- boilerplate_import(data_path = temp_version, quiet = TRUE)
# 
# # Save with timestamp before major revision
# boilerplate_save(
#   db,
#   data_path = temp_version,
#   timestamp = TRUE,
#   confirm = FALSE,
#   quiet = FALSE
# )
# #> ✔ Saved unified database to: boilerplate_unified_20240115_143022.rds
# 
# # Later, import specific version
# # Note: Replace with your actual timestamped filename
# db_milestone <- boilerplate_import(
#   data_path = "path/to/your/boilerplate_unified_20240115_143022.rds"
# )

## ----backup-recovery----------------------------------------------------------
# # List available backups
# files <- boilerplate_list_files(data_path = temp_version)
# # Look at files$backups for backup files
# 
# # View latest backup without restoring
# backup_db <- boilerplate_restore_backup(data_path = temp_version, category = "methods")
# 
# # Restore latest backup as current version
# boilerplate_restore_backup(
#   data_path = temp_version,
#   category = "methods",
#   restore = TRUE,
#   confirm = TRUE
# )
# #> ✔ Restored backup from 20240110_120000
# 
# # Restore specific backup by timestamp
# boilerplate_restore_backup(
#   data_path = temp_version,
#   category = "methods",
#   backup_version = "20240110_120000",
#   restore = TRUE,
#   confirm = FALSE
# )

## ----workflow-example---------------------------------------------------------
# # 1. Check current versions
# files <- boilerplate_list_files(data_path = temp_version, category = "methods")
# 
# # 2. Save current work with timestamp
# methods_db <- boilerplate_import("methods", data_path = temp_version, quiet = TRUE)
# boilerplate_save(
#   methods_db,
#   data_path = temp_version,
#   category = "methods",
#   timestamp = TRUE,
#   confirm = FALSE,
#   quiet = TRUE
# )
# 
# # 3. Make changes
# methods_db$new_method <- "New methodology text"
# boilerplate_save(methods_db, data_path = temp_version, category = "methods", confirm = FALSE, quiet = TRUE)
# 
# # 4. If changes were problematic, restore from backup
# boilerplate_restore_backup(data_path = temp_version, category = "methods", restore = TRUE, confirm = FALSE)
# 
# # 5. Compare versions
# current <- boilerplate_import("methods", data_path = temp_version, quiet = TRUE)
# old_version <- boilerplate_import(
#   data_path = "path/to/your/methods_db_20240110_120000.rds"
# )

## ----git-integration----------------------------------------------------------
# # Save timestamped version for Git commit
# boilerplate_save(db, data_path = temp_version, timestamp = TRUE, confirm = FALSE, quiet = TRUE)
# 
# # Add to Git
# # git add boilerplate/data/boilerplate_unified_*.rds
# # git commit -m "Snapshot before major refactoring"

## ----troubleshooting----------------------------------------------------------
# # List all files including backups
# all_files <- boilerplate_list_files(data_path = temp_version)
# 
# # Check modification times
# # The most recently modified files appear first
# print(all_files$timestamped[1:5, c("file", "modified")])
# print(all_files$backups[1:5, c("file", "modified")])

## ----recovery-----------------------------------------------------------------
# # Try loading backup
# backup_db <- tryCatch(
#   boilerplate_restore_backup(data_path = temp_version, category = "methods"),
#   error = function(e) {
#     message("Backup corrupted, trying older version...")
#     # List files and manually load an older one
#     files <- boilerplate_list_files(data_path = temp_version, category = "methods")
#     if (nrow(files$timestamped) > 0) {
#       boilerplate_import(data_path = files$timestamped$path[2])
#     }
#   }
# )

