/*
 * Decompiled with CFR 0.152.
 */
package dr.evolution.tree;

import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;
import dr.evolution.tree.TreeNodeFilter;

public interface TreeTrait<T> {
    public String getTraitName();

    public Intent getIntent();

    public Class getTraitClass();

    public T getTrait(Tree var1, NodeRef var2);

    public String getTraitString(Tree var1, NodeRef var2);

    public boolean getLoggable();

    public static class FilteredDA
    extends Filtered<double[]> {
        public FilteredDA(TreeTrait<double[]> treeTrait, TreeNodeFilter treeNodeFilter) {
            super(treeTrait, treeNodeFilter);
        }

        public FilteredDA(String string, TreeTrait<double[]> treeTrait, TreeNodeFilter treeNodeFilter) {
            super(string, treeTrait, treeNodeFilter);
        }

        @Override
        protected double[] addToMatrix(double[] dArray, double[] dArray2) {
            return SumOverTreeDA.addToMatrixStatic(dArray, dArray2);
        }

        @Override
        protected double[] zero(double[] dArray) {
            return new double[dArray.length];
        }

        @Override
        public Class getTraitClass() {
            return double[].class;
        }

        @Override
        public String getTraitString(Tree tree, NodeRef nodeRef) {
            return DA.formatTrait((double[])this.getTrait(tree, nodeRef));
        }
    }

    public static class FilteredD
    extends Filtered<Double> {
        public FilteredD(TreeTrait<Double> treeTrait, TreeNodeFilter treeNodeFilter) {
            super(treeTrait, treeNodeFilter);
        }

        public FilteredD(String string, TreeTrait<Double> treeTrait, TreeNodeFilter treeNodeFilter) {
            super(string, treeTrait, treeNodeFilter);
        }

        @Override
        protected Double addToMatrix(Double d, Double d2) {
            return SumOverTreeD.addToMatrixStatic(d, d2);
        }

        @Override
        protected Double zero(Double d) {
            return 0.0;
        }

        @Override
        public Class getTraitClass() {
            return Double.class;
        }

        @Override
        public String getTraitString(Tree tree, NodeRef nodeRef) {
            return D.formatTrait((Double)this.getTrait(tree, nodeRef));
        }
    }

    public static abstract class Filtered<T>
    extends DefaultBehavior
    implements TreeTrait<T> {
        private static final String NAME_PREFIX = "filtered_";
        private final TreeTrait<T> base;
        private final String name;
        private final TreeNodeFilter treeNodeFilter;

        public Filtered(TreeTrait<T> treeTrait, TreeNodeFilter treeNodeFilter) {
            this(NAME_PREFIX + treeTrait.getTraitName(), treeTrait, treeNodeFilter);
        }

        public Filtered(String string, TreeTrait<T> treeTrait, TreeNodeFilter treeNodeFilter) {
            this.base = treeTrait;
            this.name = string;
            this.treeNodeFilter = treeNodeFilter;
        }

        @Override
        public String getTraitName() {
            return this.name;
        }

        @Override
        public Intent getIntent() {
            return this.base.getIntent();
        }

        @Override
        public T getTrait(Tree tree, NodeRef nodeRef) {
            Object var3_3 = null;
            if (this.getIntent() == Intent.WHOLE_TREE) {
                for (int i = 0; i < tree.getNodeCount(); ++i) {
                    NodeRef nodeRef2 = tree.getNode(i);
                    if (!this.treeNodeFilter.includeNode(tree, nodeRef2)) continue;
                    var3_3 = this.addToMatrix(var3_3, this.base.getTrait(tree, nodeRef2));
                }
            } else {
                var3_3 = this.base.getTrait(tree, nodeRef);
                if (!this.treeNodeFilter.includeNode(tree, nodeRef)) {
                    var3_3 = this.zero(var3_3);
                }
            }
            return var3_3;
        }

        @Override
        public boolean getLoggable() {
            return this.base.getLoggable();
        }

        protected abstract T addToMatrix(T var1, T var2);

        protected abstract T zero(T var1);
    }

    public static class PickEntryI
    extends PickEntry<Integer, int[]> {
        public PickEntryI(TreeTrait<int[]> treeTrait, int n) {
            super(treeTrait, n);
        }

        public PickEntryI(String string, TreeTrait<int[]> treeTrait, int n) {
            super(string, treeTrait, n);
        }

        @Override
        public Class getTraitClass() {
            return Double.class;
        }

        @Override
        public Integer getTrait(Tree tree, NodeRef nodeRef) {
            return ((int[])this.base.getTrait(tree, nodeRef))[this.index];
        }

        @Override
        public String getTraitString(Tree tree, NodeRef nodeRef) {
            return I.formatTrait(this.getTrait(tree, nodeRef));
        }
    }

    public static class PickEntryDAndScale
    extends PickEntryD {
        public PickEntryDAndScale(TreeTrait<double[]> treeTrait, int n) {
            super(treeTrait, n);
        }

        public PickEntryDAndScale(String string, TreeTrait<double[]> treeTrait, int n) {
            super(string, treeTrait, n);
        }

        @Override
        public Double getTrait(Tree tree, NodeRef nodeRef) {
            return ((double[])this.base.getTrait(tree, nodeRef))[this.index] / tree.getBranchLength(nodeRef);
        }
    }

    public static class PickEntryD
    extends PickEntry<Double, double[]> {
        public PickEntryD(TreeTrait<double[]> treeTrait, int n) {
            super(treeTrait, n);
        }

        public PickEntryD(String string, TreeTrait<double[]> treeTrait, int n) {
            super(string, treeTrait, n);
        }

        @Override
        public Class getTraitClass() {
            return Double.class;
        }

        @Override
        public Double getTrait(Tree tree, NodeRef nodeRef) {
            return ((double[])this.base.getTrait(tree, nodeRef))[this.index];
        }

        @Override
        public String getTraitString(Tree tree, NodeRef nodeRef) {
            return D.formatTrait(this.getTrait(tree, nodeRef));
        }
    }

    public static abstract class PickEntry<T, TA>
    extends DefaultBehavior
    implements TreeTrait<T> {
        protected TreeTrait<TA> base;
        private String name;
        protected int index;

        public PickEntry(TreeTrait<TA> treeTrait, int n) {
            this(treeTrait.getTraitName() + "_" + (n + 1), treeTrait, n);
        }

        public PickEntry(String string, TreeTrait<TA> treeTrait, int n) {
            this.name = string;
            this.base = treeTrait;
            this.index = n;
        }

        @Override
        public String getTraitName() {
            return this.name;
        }

        @Override
        public Intent getIntent() {
            return this.base.getIntent();
        }
    }

    public static class SumAcrossArrayD
    extends SumAcrossArray<Double, double[]> {
        public SumAcrossArrayD(String string, TreeTrait<double[]> treeTrait) {
            super(string, treeTrait);
        }

        public SumAcrossArrayD(TreeTrait<double[]> treeTrait) {
            super(treeTrait);
        }

        @Override
        public Class getTraitClass() {
            return Double.class;
        }

        @Override
        protected Double reduce(double[] dArray) {
            double d = 0.0;
            for (double d2 : dArray) {
                d += d2;
            }
            return d;
        }

        @Override
        public String getTraitString(Tree tree, NodeRef nodeRef) {
            return D.formatTrait((Double)this.getTrait(tree, nodeRef));
        }
    }

    public static abstract class SumAcrossArray<T, TA>
    extends DefaultBehavior
    implements TreeTrait<T> {
        private TreeTrait<TA> base;
        private String name;
        public static final String NAME_PREFIX = "sumAcrossArray_";

        public SumAcrossArray(TreeTrait<TA> treeTrait) {
            this(NAME_PREFIX + treeTrait.getTraitName(), treeTrait);
        }

        public SumAcrossArray(String string, TreeTrait<TA> treeTrait) {
            this.name = string;
            this.base = treeTrait;
        }

        @Override
        public String getTraitName() {
            return this.name;
        }

        @Override
        public Intent getIntent() {
            return this.base.getIntent();
        }

        @Override
        public T getTrait(Tree tree, NodeRef nodeRef) {
            TA TA = this.base.getTrait(tree, nodeRef);
            if (TA == null) {
                return null;
            }
            return this.reduce(TA);
        }

        @Override
        public boolean getLoggable() {
            return this.base.getLoggable();
        }

        protected abstract T reduce(TA var1);
    }

    public static class SumOverTreeD
    extends SumOverTree<Double> {
        public SumOverTreeD(String string, TreeTrait<Double> treeTrait, boolean bl, boolean bl2) {
            super(string, treeTrait, bl, bl2);
        }

        public SumOverTreeD(String string, TreeTrait<Double> treeTrait) {
            super(string, treeTrait);
        }

        public SumOverTreeD(TreeTrait<Double> treeTrait) {
            super(treeTrait);
        }

        @Override
        public String getTraitString(Tree tree, NodeRef nodeRef) {
            return D.formatTrait((Double)this.getTrait(tree, nodeRef));
        }

        @Override
        public Class getTraitClass() {
            return double[].class;
        }

        @Override
        protected Double addToMatrix(Double d, Double d2) {
            return SumOverTreeD.addToMatrixStatic(d, d2);
        }

        protected static Double addToMatrixStatic(Double d, Double d2) {
            if (d2 == null) {
                return d;
            }
            if (d == null) {
                d = 0.0;
            }
            d = d + d2;
            return d;
        }
    }

    public static class SumOverTreeDA
    extends SumOverTree<double[]> {
        public SumOverTreeDA(String string, TreeTrait<double[]> treeTrait, boolean bl, boolean bl2) {
            super(string, treeTrait, bl, bl2);
        }

        public SumOverTreeDA(String string, TreeTrait<double[]> treeTrait) {
            super(string, treeTrait);
        }

        public SumOverTreeDA(TreeTrait<double[]> treeTrait) {
            super(treeTrait);
        }

        @Override
        public String getTraitString(Tree tree, NodeRef nodeRef) {
            return DA.formatTrait((double[])this.getTrait(tree, nodeRef));
        }

        @Override
        public Class getTraitClass() {
            return double[].class;
        }

        @Override
        protected double[] addToMatrix(double[] dArray, double[] dArray2) {
            return SumOverTreeDA.addToMatrixStatic(dArray, dArray2);
        }

        protected static double[] addToMatrixStatic(double[] dArray, double[] dArray2) {
            if (dArray2 == null) {
                return dArray;
            }
            int n = dArray2.length;
            if (dArray == null) {
                dArray = new double[n];
            }
            for (int i = 0; i < n; ++i) {
                int n2 = i;
                dArray[n2] = dArray[n2] + dArray2[i];
            }
            return dArray;
        }
    }

    public static abstract class SumOverTree<T>
    extends DefaultBehavior
    implements TreeTrait<T> {
        private static final String NAME_PREFIX = "sumOverTree_";
        private final TreeTrait<T> base;
        private final String name;
        private final boolean includeExternalNodes;
        private final boolean includeInternalNodes;

        public SumOverTree(TreeTrait<T> treeTrait) {
            this(NAME_PREFIX + treeTrait.getTraitName(), treeTrait);
        }

        public SumOverTree(String string, TreeTrait<T> treeTrait) {
            this(string, treeTrait, true, true);
        }

        public SumOverTree(String string, TreeTrait<T> treeTrait, boolean bl, boolean bl2) {
            this.base = treeTrait;
            this.name = string;
            this.includeExternalNodes = bl;
            this.includeInternalNodes = bl2;
        }

        @Override
        public String getTraitName() {
            return this.name;
        }

        @Override
        public Intent getIntent() {
            return Intent.WHOLE_TREE;
        }

        @Override
        public T getTrait(Tree tree, NodeRef nodeRef) {
            int n;
            Object var3_3 = null;
            if (this.includeExternalNodes) {
                for (n = 0; n < tree.getExternalNodeCount(); ++n) {
                    var3_3 = this.addToMatrix(var3_3, this.base.getTrait(tree, tree.getExternalNode(n)));
                }
            }
            if (this.includeInternalNodes) {
                for (n = 0; n < tree.getInternalNodeCount(); ++n) {
                    var3_3 = this.addToMatrix(var3_3, this.base.getTrait(tree, tree.getInternalNode(n)));
                }
            }
            return var3_3;
        }

        @Override
        public boolean getLoggable() {
            return this.base.getLoggable();
        }

        protected abstract T addToMatrix(T var1, T var2);
    }

    public static abstract class IA
    extends DefaultBehavior
    implements TreeTrait<int[]> {
        @Override
        public Class getTraitClass() {
            return int[].class;
        }

        @Override
        public String getTraitString(Tree tree, NodeRef nodeRef) {
            return IA.formatTrait((int[])this.getTrait(tree, nodeRef));
        }

        public static String formatTrait(int[] nArray) {
            if (nArray == null || nArray.length == 0) {
                return null;
            }
            if (nArray.length > 1) {
                StringBuilder stringBuilder = new StringBuilder("{");
                stringBuilder.append(nArray[0]);
                for (int i = 1; i < nArray.length; ++i) {
                    stringBuilder.append(",");
                    stringBuilder.append(nArray[i]);
                }
                stringBuilder.append("}");
                return stringBuilder.toString();
            }
            return Integer.toString(nArray[0]);
        }
    }

    public static abstract class SA
    extends DefaultBehavior
    implements TreeTrait<String[]> {
        @Override
        public Class getTraitClass() {
            return String[].class;
        }

        @Override
        public String getTraitString(Tree tree, NodeRef nodeRef) {
            return SA.formatTrait((String[])this.getTrait(tree, nodeRef), this.getFormatAsArray());
        }

        public static String formatTrait(String[] stringArray, boolean bl) {
            if (stringArray == null || stringArray.length == 0) {
                return null;
            }
            if (stringArray.length > 1 || bl) {
                StringBuilder stringBuilder = new StringBuilder("{");
                stringBuilder.append(stringArray[0]);
                for (int i = 1; i < stringArray.length; ++i) {
                    stringBuilder.append(",");
                    stringBuilder.append(stringArray[i]);
                }
                stringBuilder.append("}");
                return stringBuilder.toString();
            }
            return stringArray[0];
        }
    }

    public static abstract class DA
    extends DefaultBehavior
    implements TreeTrait<double[]> {
        @Override
        public Class getTraitClass() {
            return double[].class;
        }

        @Override
        public String getTraitString(Tree tree, NodeRef nodeRef) {
            return DA.formatTrait((double[])this.getTrait(tree, nodeRef));
        }

        public static String formatTrait(double[] dArray) {
            if (dArray == null || dArray.length == 0) {
                return null;
            }
            if (dArray.length > 1) {
                StringBuilder stringBuilder = new StringBuilder("{");
                stringBuilder.append(dArray[0]);
                for (int i = 1; i < dArray.length; ++i) {
                    stringBuilder.append(",");
                    stringBuilder.append(dArray[i]);
                }
                stringBuilder.append("}");
                return stringBuilder.toString();
            }
            return Double.toString(dArray[0]);
        }

        public static DA factory(final TraitInfo<double[]> traitInfo) {
            DA dA = new DA(){

                @Override
                public String getTraitName() {
                    return traitInfo.getTraitName();
                }

                @Override
                public Intent getIntent() {
                    return traitInfo.getTraitIntent();
                }

                @Override
                public Class getTraitClass() {
                    return traitInfo.getTraitClass();
                }

                @Override
                public double[] getTrait(Tree tree, NodeRef nodeRef) {
                    return (double[])traitInfo.getTrait(tree, nodeRef);
                }

                @Override
                public boolean getLoggable() {
                    return traitInfo.isTraitLoggable();
                }
            };
            return dA;
        }
    }

    public static abstract class S
    extends DefaultBehavior
    implements TreeTrait<String> {
        @Override
        public Class getTraitClass() {
            return String.class;
        }

        @Override
        public String getTraitString(Tree tree, NodeRef nodeRef) {
            return (String)this.getTrait(tree, nodeRef);
        }
    }

    public static abstract class I
    extends DefaultBehavior
    implements TreeTrait<Integer> {
        @Override
        public Class getTraitClass() {
            return Integer.class;
        }

        @Override
        public String getTraitString(Tree tree, NodeRef nodeRef) {
            return I.formatTrait((Integer)this.getTrait(tree, nodeRef));
        }

        public static String formatTrait(Integer n) {
            if (n == null) {
                return null;
            }
            return n.toString();
        }
    }

    public static abstract class D
    extends DefaultBehavior
    implements TreeTrait<Double> {
        @Override
        public Class getTraitClass() {
            return Double.class;
        }

        @Override
        public String getTraitString(Tree tree, NodeRef nodeRef) {
            return D.formatTrait((Double)this.getTrait(tree, nodeRef));
        }

        public static String formatTrait(Double d) {
            if (d == null) {
                return null;
            }
            return d.toString();
        }
    }

    public static class DefaultBehavior {
        public boolean getLoggable() {
            return true;
        }

        public boolean getFormatAsArray() {
            return false;
        }
    }

    public static interface TraitInfo<T> {
        public String getTraitName();

        public Intent getTraitIntent();

        public Class getTraitClass();

        public T getTrait(Tree var1, NodeRef var2);

        public boolean isTraitLoggable();
    }

    public static enum Intent {
        NODE,
        BRANCH,
        WHOLE_TREE;

    }
}

