/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.arg.operators;

import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;
import dr.evolution.tree.TreeUtils;
import dr.evomodel.arg.ARGModel;
import dr.evomodel.arg.operators.ARGOperatorFailedException;
import dr.inference.model.CompoundParameter;
import dr.inference.model.Parameter;
import dr.inference.operators.AbstractAdaptableOperator;
import dr.inference.operators.AdaptationMode;
import dr.math.MathUtils;
import dr.math.functionEval.GammaFunction;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import java.util.ArrayList;

public class ObsoleteARGAddRemoveEventOperator
extends AbstractAdaptableOperator {
    public static final String SUBTREE_SLIDE = "addremoveARGEvent";
    public static final String SWAP_RATES = "swapRates";
    public static final String SWAP_TRAITS = "swapTraits";
    public static final String MAX_VALUE = "maxTips";
    public static final String SINGLE_PARTITION = "singlePartitionProbability";
    public static final String IS_RECOMBINATION = "isRecombination";
    public static final String JUST_INTERNAL = "justInternalNodes";
    public static final String INTERNAL_AND_ROOT = "internalAndRootNodes";
    public static final String NODE_RATES = "nodeRates";
    private ARGModel arg = null;
    private double size = 1.0;
    private boolean gaussian = false;
    private double singlePartitionProbability = 0.0;
    private boolean isRecombination = false;
    private CompoundParameter internalNodeParameters;
    private CompoundParameter internalAndRootNodeParameters;
    private CompoundParameter nodeRates;
    private int times = 0;
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        private final XMLSyntaxRule[] rules = new XMLSyntaxRule[]{AttributeRule.newIntegerRule("weight"), AttributeRule.newDoubleRule("size"), AttributeRule.newBooleanRule("gaussian"), AttributeRule.newBooleanRule("swapRates", true), AttributeRule.newBooleanRule("swapTraits", true), AttributeRule.newBooleanRule("autoOptimize", true), new ElementRule(ARGModel.class)};

        @Override
        public String getParserName() {
            return ObsoleteARGAddRemoveEventOperator.SUBTREE_SLIDE;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            boolean bl = false;
            boolean bl2 = false;
            double d = 0.0;
            boolean bl3 = false;
            AdaptationMode adaptationMode = AdaptationMode.parseMode(xMLObject);
            if (xMLObject.hasAttribute(ObsoleteARGAddRemoveEventOperator.SINGLE_PARTITION)) {
                d = xMLObject.getDoubleAttribute(ObsoleteARGAddRemoveEventOperator.SINGLE_PARTITION);
            }
            if (xMLObject.hasAttribute(ObsoleteARGAddRemoveEventOperator.IS_RECOMBINATION)) {
                bl3 = xMLObject.getBooleanAttribute(ObsoleteARGAddRemoveEventOperator.IS_RECOMBINATION);
            }
            if (xMLObject.hasAttribute(ObsoleteARGAddRemoveEventOperator.SWAP_RATES)) {
                bl = xMLObject.getBooleanAttribute(ObsoleteARGAddRemoveEventOperator.SWAP_RATES);
            }
            if (xMLObject.hasAttribute(ObsoleteARGAddRemoveEventOperator.SWAP_TRAITS)) {
                bl2 = xMLObject.getBooleanAttribute(ObsoleteARGAddRemoveEventOperator.SWAP_TRAITS);
            }
            Object object = xMLObject.getChild(ARGModel.class);
            ARGModel aRGModel = null;
            if (object instanceof ARGModel) {
                aRGModel = (ARGModel)object;
            } else {
                System.err.println("Must specify a variable size tree model to use the AddRemoveSubtreeOperators");
                System.exit(-1);
            }
            CompoundParameter compoundParameter = null;
            CompoundParameter compoundParameter2 = null;
            CompoundParameter compoundParameter3 = null;
            int n = xMLObject.getIntegerAttribute("weight");
            double d2 = xMLObject.getDoubleAttribute("size");
            boolean bl4 = xMLObject.getBooleanAttribute("gaussian");
            return new ObsoleteARGAddRemoveEventOperator(aRGModel, n, d2, bl4, bl, bl2, adaptationMode, compoundParameter, compoundParameter2, compoundParameter3, d, bl3);
        }

        @Override
        public String getParserDescription() {
            return "An operator that slides a subarg.";
        }

        @Override
        public Class getReturnType() {
            return ObsoleteARGAddRemoveEventOperator.class;
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }
    };

    public ObsoleteARGAddRemoveEventOperator(ARGModel aRGModel, int n, double d, boolean bl, boolean bl2, boolean bl3, AdaptationMode adaptationMode, CompoundParameter compoundParameter, CompoundParameter compoundParameter2, CompoundParameter compoundParameter3, double d2, boolean bl4) {
        super(adaptationMode);
        this.arg = aRGModel;
        this.setWeight(n);
        this.size = d;
        this.gaussian = bl;
        this.internalNodeParameters = compoundParameter;
        this.internalAndRootNodeParameters = compoundParameter2;
        this.nodeRates = compoundParameter3;
        this.singlePartitionProbability = d2;
        this.isRecombination = bl4;
    }

    @Override
    public double doOperation() {
        double d;
        block3: {
            d = 0.0;
            try {
                d = MathUtils.nextDouble() < 0.5 ? this.AddOperation() : this.RemoveOperation();
            }
            catch (ARGOperatorFailedException aRGOperatorFailedException) {
                if (aRGOperatorFailedException.getMessage().compareTo("No reassortment nodes to remove.") == 0) break block3;
                System.err.println("Catch: " + aRGOperatorFailedException.getMessage());
            }
        }
        if (this.arg.isBifurcationDoublyLinked(this.arg.getRoot())) {
            throw new RuntimeException("trouble with double-rooted root");
        }
        return d;
    }

    private int findPotentialReassortmentNodes(ArrayList<NodeRef> arrayList) {
        int n = 0;
        int n2 = this.arg.getNodeCount();
        for (int i = 0; i < n2; ++i) {
            ARGModel.Node node = (ARGModel.Node)this.arg.getNode(i);
            if (node.leftParent == null) continue;
            arrayList.add(node);
            ++n;
            if (!node.isReassortment()) continue;
            arrayList.add(node);
            ++n;
        }
        return n;
    }

    private int findCurrentReassortmentNodes(ArrayList<NodeRef> arrayList) {
        int n = 0;
        int n2 = this.arg.getNodeCount();
        ARGModel.Node node = (ARGModel.Node)this.arg.getRoot();
        for (int i = 0; i < n2; ++i) {
            ARGModel.Node node2 = (ARGModel.Node)this.arg.getNode(i);
            if (!node2.isReassortment() || node2.leftParent == node || node2.rightParent == node) continue;
            if (arrayList != null) {
                arrayList.add(node2);
            }
            ++n;
        }
        return n;
    }

    private double RemoveOperation() throws ARGOperatorFailedException {
        ARGModel.Node node;
        double d = 0.0;
        ArrayList<NodeRef> arrayList = new ArrayList<NodeRef>();
        int n = this.findCurrentReassortmentNodes(arrayList);
        if (n == 0) {
            throw new ARGOperatorFailedException("No reassortment nodes to remove.");
        }
        ARGModel.Node node2 = (ARGModel.Node)arrayList.get(MathUtils.nextInt(n));
        d += Math.log(n);
        double d2 = 0.0;
        double d3 = 0.0;
        this.arg.beginTreeEdit();
        boolean bl = false;
        ARGModel.Node node3 = node2.leftParent;
        ARGModel.Node node4 = node2.leftChild;
        if (node2.leftParent == node2.rightParent) {
            node = node3.leftParent;
            d2 = this.arg.getNodeHeight(node3) - this.arg.getNodeHeight(node4);
            d3 = this.arg.getNodeHeight(node) - this.arg.getNodeHeight(node4);
            if (this.arg.isRoot(node3)) {
                this.arg.setRoot(node4);
            } else {
                this.arg.doubleRemoveChild(node, node3);
                this.arg.doubleRemoveChild(node2, node4);
                if (node.bifurcation) {
                    this.arg.singleAddChild(node, node4);
                } else {
                    this.arg.doubleAddChild(node, node4);
                }
            }
            bl = true;
        } else {
            node = node2.leftParent;
            ARGModel.Node node5 = node2.rightParent;
            if (!node.bifurcation && !node5.bifurcation || !node.bifurcation && node5.isRoot() || !node5.bifurcation && node.isRoot()) {
                this.arg.endTreeEdit();
                throw new ARGOperatorFailedException("Not reversible deletion.");
            }
            if (!node.bifurcation || node.isRoot()) {
                node = node2.rightParent;
                node5 = node2.leftParent;
            } else if (node5.bifurcation && !node5.isRoot()) {
                if (MathUtils.nextDouble() < 0.5) {
                    node = node2.rightParent;
                    node5 = node2.leftParent;
                }
                d += Math.log(2.0);
            }
            ARGModel.Node node6 = node.leftParent;
            ARGModel.Node node7 = node.leftChild;
            if (node7 == node2) {
                node7 = node.rightChild;
            }
            d2 = Math.min(this.arg.getNodeHeight(node), this.arg.getNodeHeight(node5)) - this.arg.getNodeHeight(node4);
            d3 = this.arg.getNodeHeight(node6) - Math.max(this.arg.getNodeHeight(node4), this.arg.getNodeHeight(node7));
            if (node6.bifurcation) {
                this.arg.singleRemoveChild(node6, node);
            } else {
                this.arg.doubleRemoveChild(node6, node);
            }
            this.arg.singleRemoveChild(node, node7);
            if (node5.bifurcation) {
                this.arg.singleRemoveChild(node5, node2);
            } else {
                this.arg.doubleRemoveChild(node5, node2);
            }
            this.arg.doubleRemoveChild(node2, node4);
            if (node7 != node4) {
                if (node6.bifurcation) {
                    this.arg.singleAddChild(node6, node7);
                } else {
                    this.arg.doubleAddChild(node6, node7);
                }
                if (node5.bifurcation) {
                    this.arg.singleAddChild(node5, node4);
                } else {
                    this.arg.doubleAddChild(node5, node4);
                }
            } else {
                if (node6.bifurcation) {
                    this.arg.singleAddChildWithOneParent(node6, node7);
                } else {
                    this.arg.doubleAddChildWithOneParent(node6, node7);
                }
                if (node5.bifurcation) {
                    this.arg.singleAddChildWithOneParent(node5, node4);
                } else {
                    this.arg.doubleAddChildWithOneParent(node5, node4);
                }
            }
            bl = true;
            if (node4.getHeight() > node5.getHeight() || node7.getHeight() > node6.getHeight()) {
                this.arg.endTreeEdit();
                throw new RuntimeException("How did I get here?");
            }
            node3 = node;
        }
        if (bl) {
            this.arg.contractARGWithRecombinant(node3, node2, this.internalNodeParameters, this.internalAndRootNodeParameters, this.nodeRates);
        }
        this.arg.pushTreeSizeChangedEvent();
        this.arg.endTreeEdit();
        d -= Math.log(this.arg.getNodeCount() + this.arg.getReassortmentNodeCount() - 1);
        d -= Math.log(this.findPotentialAttachmentSisters(node4, this.arg.getNodeHeight(node4), null));
        int n2 = this.arg.getInternalNodeCount() - 1;
        d += ObsoleteARGAddRemoveEventOperator.lnGamma(n2) - ObsoleteARGAddRemoveEventOperator.lnGamma(n2 + 2);
        d += 3.0 * Math.log(2.0);
        d = 0.0;
        return d;
    }

    private static double lnGamma(double d) {
        if (d == 1.0 || d == 2.0) {
            return 0.0;
        }
        return GammaFunction.logGamma(d);
    }

    private void checkAllHeights() {
        int n;
        int n2 = this.arg.getInternalNodeCount();
        System.err.println("# internal nodes = " + n2);
        int n3 = this.internalNodeParameters.getParameterCount();
        System.err.println("VSCP (" + n3 + ")");
        for (n = 0; n < n3; ++n) {
            System.err.println(this.internalNodeParameters.getParameterValue(n));
        }
        n3 = this.arg.getInternalNodeCount();
        System.err.println("Checking all internal nodes (" + n3 + ") via tree:");
        for (n = 0; n < n3; ++n) {
            NodeRef nodeRef = this.arg.getInternalNode(n);
            System.err.print(TreeUtils.uniqueNewick(this.arg, nodeRef) + " ");
            System.err.println(((ARGModel.Node)nodeRef).getHeight());
        }
    }

    private int findPotentialAttachmentSisters(NodeRef nodeRef, double d, ArrayList<NodeRef> arrayList) {
        int n = 0;
        int n2 = this.arg.getNodeCount();
        for (int i = 0; i < n2; ++i) {
            ARGModel.Node node = (ARGModel.Node)this.arg.getNode(i);
            if (node.isRoot()) continue;
            if (this.arg.getNodeHeight(node.leftParent) > d) {
                if (arrayList != null) {
                    arrayList.add(node);
                }
                ++n;
            }
            if (!node.isReassortment() || !(this.arg.getNodeHeight(node.rightParent) > d)) continue;
            if (arrayList != null) {
                arrayList.add(node);
            }
            ++n;
        }
        return n;
    }

    private double drawRandomPartitioning(Parameter parameter) {
        double d = 0.0;
        int n = this.arg.getNumberOfPartitions();
        if (n == 2) {
            boolean bl = MathUtils.nextBoolean();
            if (parameter != null) {
                if (bl) {
                    parameter.setParameterValueQuietly(0, 1.0);
                } else {
                    parameter.setParameterValueQuietly(1, 1.0);
                }
            }
            return Math.log(2.0);
        }
        d = this.isRecombination ? (d += this.drawRandomRecombination(parameter)) : (d += this.drawRandomReassortment(parameter));
        return d;
    }

    private double drawRandomReassortment(Parameter parameter) {
        int n = this.arg.getNumberOfPartitions();
        double d = 0.0;
        if (MathUtils.nextDouble() < this.singlePartitionProbability) {
            if (parameter != null) {
                parameter.setParameterValueQuietly(MathUtils.nextInt(n), 1.0);
            }
            return Math.log(n);
        }
        int[] nArray = MathUtils.permuted(n);
        int n2 = MathUtils.nextInt(n - 1);
        for (int i = 0; i < n; ++i) {
            d += Math.log(i + 1);
            if (i <= n2 || parameter == null) continue;
            parameter.setParameterValueQuietly(nArray[i], 1.0);
        }
        return d += Math.log(n - 1);
    }

    private double drawRandomRecombination(Parameter parameter) {
        int n = this.arg.getNumberOfPartitions();
        double d = 0.0;
        double d2 = MathUtils.nextInt(2);
        double d3 = 1.0 - d2;
        d += Math.log(2.0);
        if (parameter != null) {
            int n2;
            int n3 = MathUtils.nextInt(n - 1);
            for (n2 = 0; n2 <= n3; ++n2) {
                parameter.setParameterValueQuietly(n2, d2);
            }
            for (n2 = n3 + 1; n2 < n; ++n2) {
                parameter.setParameterValueQuietly(n2, d3);
            }
        }
        return d += Math.log(n - 1);
    }

    private double AddOperation() throws ARGOperatorFailedException {
        ArrayList<NodeRef> arrayList;
        double d = 0.0;
        ArrayList<NodeRef> arrayList2 = new ArrayList<NodeRef>();
        int n = this.findPotentialReassortmentNodes(arrayList2);
        if (n == 0) {
            System.err.println("Should never get here AA");
            System.exit(-1);
            throw new ARGOperatorFailedException("No more nodes to recombine.");
        }
        ARGModel.Node node = (ARGModel.Node)arrayList2.get(MathUtils.nextInt(n));
        ARGModel.Node node2 = node.leftParent;
        ARGModel.Node node3 = node.rightParent;
        ARGModel.Node node4 = node2;
        if (node2 != node3 && MathUtils.nextDouble() > 0.5) {
            node4 = node3;
        }
        d += Math.log(n);
        double d2 = this.arg.getNodeHeight(node);
        int n2 = this.findPotentialAttachmentSisters(node, d2, arrayList = new ArrayList<NodeRef>());
        if (n2 == 0) {
            throw new ARGOperatorFailedException("no more attachment points for this recomb");
        }
        ARGModel.Node node5 = (ARGModel.Node)arrayList.get(MathUtils.nextInt(n2));
        ARGModel.Node node6 = node5.leftParent;
        ARGModel.Node node7 = node5.rightParent;
        ARGModel.Node node8 = node6;
        if (node6 != node7) {
            if (this.arg.getNodeHeight(node6) <= d2) {
                node8 = node7;
            } else if (this.arg.getNodeHeight(node7) > d2 && MathUtils.nextDouble() > 0.5) {
                node8 = node7;
            }
        }
        d += Math.log(n2);
        ARGModel.Node node9 = this.arg.new ARGModel.Node();
        ARGModel.Node node10 = this.arg.new ARGModel.Node();
        node10.bifurcation = false;
        double d3 = node5.getHeight();
        if (d3 < d2) {
            d3 = d2;
        }
        double d4 = this.arg.getNodeHeight(node8);
        double d5 = d4 - d3;
        double d6 = d3 + MathUtils.nextDouble() * d5;
        d -= Math.log(d5);
        node9.heightParameter = new Parameter.Default(d6);
        node9.setupHeightBounds();
        d += Math.log(d5);
        double d7 = d6;
        double d8 = this.arg.getNodeHeight(node4);
        if (d7 > d8) {
            d7 = d8;
        }
        double d9 = this.arg.getNodeHeight(node);
        d5 = d7 - d9;
        d6 = d9 + MathUtils.nextDouble() * d5;
        d -= Math.log(d5);
        node10.heightParameter = new Parameter.Default(d6);
        node10.setupHeightBounds();
        d += Math.log(d5);
        this.arg.beginTreeEdit();
        if (node8.bifurcation) {
            this.arg.singleRemoveChild(node8, node5);
        } else {
            this.arg.doubleRemoveChild(node8, node5);
        }
        if (node5 != node) {
            if (node4.bifurcation) {
                this.arg.singleRemoveChild(node4, node);
            } else {
                this.arg.doubleRemoveChild(node4, node);
            }
        }
        if (node8.bifurcation) {
            this.arg.singleAddChild(node8, node9);
        } else {
            this.arg.doubleAddChild(node8, node9);
        }
        if (node5 != node) {
            this.arg.singleAddChild(node9, node5);
        }
        this.arg.doubleAddChild(node10, node);
        Parameter.Default default_ = new Parameter.Default(this.arg.getNumberOfPartitions());
        if (node5 != node) {
            this.arg.addChildAsRecombinant(node9, node4, node10, default_);
        } else {
            this.arg.addChildAsRecombinant(node9, node9, node10, default_);
        }
        this.arg.expandARGWithRecombinant(node9, node10, this.internalNodeParameters, this.internalAndRootNodeParameters, this.nodeRates);
        this.arg.pushTreeSizeChangedEvent();
        this.arg.endTreeEdit();
        d -= Math.log(this.findCurrentReassortmentNodes(null));
        if (!(node.leftParent.isBifurcation() && node.rightParent.isRoot() || node.rightParent.isBifurcation() && node.leftParent.isRoot())) {
            d -= Math.log(2.0);
        }
        int n3 = this.arg.getInternalNodeCount() - 1;
        d += ObsoleteARGAddRemoveEventOperator.lnGamma(n3) - ObsoleteARGAddRemoveEventOperator.lnGamma(n3 - 2);
        d = 0.0;
        return d;
    }

    public void sanityCheck() {
        int n = this.arg.getNodeCount();
        for (int i = 0; i < n; ++i) {
            ARGModel.Node node = (ARGModel.Node)this.arg.getNode(i);
            if (node.bifurcation) {
                boolean bl;
                boolean bl2 = bl = node.leftChild == node.rightChild;
                if (bl && node.leftChild != null && (node.leftChild.bifurcation || node.leftChild.leftParent != node)) {
                    System.err.println("Node " + (i + 1) + " is insane.");
                    System.err.println(this.arg.toGraphString());
                    System.exit(-1);
                }
            } else if (node.leftChild != node.rightChild) {
                System.err.println("Node " + (i + 1) + " is insane.");
                System.err.println(this.arg.toGraphString());
                System.exit(-1);
            }
            if (node.isRoot()) continue;
            double d = node.getHeight();
        }
    }

    private double getDelta() {
        if (!this.gaussian) {
            return MathUtils.nextDouble() * this.size - this.size / 2.0;
        }
        return MathUtils.nextGaussian() * this.size;
    }

    private int intersectingEdges(Tree tree, NodeRef nodeRef, double d, ArrayList arrayList) {
        NodeRef nodeRef2 = this.arg.getParent(nodeRef);
        if (this.arg.getNodeHeight(nodeRef2) < d) {
            return 0;
        }
        if (this.arg.getNodeHeight(nodeRef) < d) {
            if (arrayList != null) {
                arrayList.add(nodeRef);
            }
            return 1;
        }
        int n = 0;
        for (int i = 0; i < this.arg.getChildCount(nodeRef); ++i) {
            n += this.intersectingEdges(tree, this.arg.getChild(nodeRef, i), d, arrayList);
        }
        return n;
    }

    private NodeRef getOtherChild(Tree tree, NodeRef nodeRef, NodeRef nodeRef2) {
        if (this.arg.getChild(nodeRef, 0) == nodeRef2) {
            return this.arg.getChild(nodeRef, 1);
        }
        return this.arg.getChild(nodeRef, 0);
    }

    public double getSize() {
        return this.size;
    }

    public void setSize(double d) {
        this.size = d;
    }

    @Override
    protected double getAdaptableParameterValue() {
        return Math.log(this.getSize());
    }

    @Override
    public void setAdaptableParameterValue(double d) {
        this.setSize(Math.exp(d));
    }

    @Override
    public double getRawParameter() {
        return this.getSize();
    }

    @Override
    public String getAdaptableParameterName() {
        return "size";
    }

    @Override
    public String getOperatorName() {
        return SUBTREE_SLIDE;
    }
}

