/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.continuous;

import dr.inference.model.MatrixParameterInterface;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLSyntaxRule;
import java.util.logging.Logger;

public class StandardizeTraits {
    private static final String STANDARDIZE_TRAITS = "standardizeTraits";
    private final MatrixParameterInterface matrix;
    private final boolean[] missing;
    private final double targetSd;
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        private final XMLSyntaxRule[] rules = new XMLSyntaxRule[]{new ElementRule(MatrixParameterInterface.class)};

        @Override
        public Object parseXMLObject(XMLObject xMLObject) {
            MatrixParameterInterface matrixParameterInterface = (MatrixParameterInterface)xMLObject.getChild(MatrixParameterInterface.class);
            StandardizeTraits standardizeTraits = new StandardizeTraits(matrixParameterInterface);
            String string = standardizeTraits.doStandardization(false);
            Logger.getLogger("dr.evomodel.continuous").info(string);
            return standardizeTraits;
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }

        @Override
        public String getParserDescription() {
            return null;
        }

        @Override
        public Class getReturnType() {
            return StandardizeTraits.class;
        }

        @Override
        public String getParserName() {
            return StandardizeTraits.STANDARDIZE_TRAITS;
        }
    };

    public StandardizeTraits(MatrixParameterInterface matrixParameterInterface) {
        this(matrixParameterInterface, null, 1.0);
    }

    public StandardizeTraits(MatrixParameterInterface matrixParameterInterface, boolean[] blArray, double d) {
        this.matrix = matrixParameterInterface;
        this.missing = new boolean[matrixParameterInterface.getDimension()];
        if (blArray != null) {
            System.arraycopy(blArray, 0, this.missing, 0, blArray.length);
        }
        this.targetSd = d;
    }

    public String doStandardization(boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Trait standardization report:\n");
        int n = bl ? this.matrix.getColumnDimension() : this.matrix.getRowDimension();
        for (int i = 0; i < n; ++i) {
            MeanVariance meanVariance = this.getStatistics(this.matrix, i, bl);
            stringBuilder.append("\tBEFORE\n");
            stringBuilder.append("\tindex: ").append(i + 1).append("\n");
            stringBuilder.append("\tmean : ").append(meanVariance.mean).append("\n");
            stringBuilder.append("\tvar  : ").append(meanVariance.variance).append("\n");
            stringBuilder.append("\tcnt  : ").append(meanVariance.count).append("\n");
            this.updateValues(this.matrix, meanVariance, i, bl);
            meanVariance = this.getStatistics(this.matrix, i, bl);
            stringBuilder.append("\tAFTER\n");
            stringBuilder.append("\tindex: ").append(i + 1).append("\n");
            stringBuilder.append("\tmean : ").append(meanVariance.mean).append("\n");
            stringBuilder.append("\tvar  : ").append(meanVariance.variance).append("\n");
            stringBuilder.append("\tcnt  : ").append(meanVariance.count).append("\n\n");
        }
        return stringBuilder.toString();
    }

    private void updateValues(MatrixParameterInterface matrixParameterInterface, MeanVariance meanVariance, int n, boolean bl) {
        int n2 = bl ? matrixParameterInterface.getRowDimension() : matrixParameterInterface.getColumnDimension();
        int n3 = matrixParameterInterface.getRowDimension();
        double d = Math.sqrt(meanVariance.variance);
        int n4 = bl ? n2 * n : n;
        for (int i = 0; i < n2; ++i) {
            int n5;
            int n6 = bl ? i : n;
            double d2 = matrixParameterInterface.getParameterValue(n6, n5 = bl ? n : i);
            if (!Double.isNaN(d2) && !this.missing[n4]) {
                d2 = (d2 - meanVariance.mean) / d * this.targetSd;
                matrixParameterInterface.setParameterValueQuietly(n6, n5, d2);
            }
            n4 += bl ? 1 : n3;
        }
        matrixParameterInterface.fireParameterChangedEvent();
    }

    private MeanVariance getStatistics(MatrixParameterInterface matrixParameterInterface, int n, boolean bl) {
        double d = 0.0;
        double d2 = 0.0;
        int n2 = 0;
        int n3 = bl ? matrixParameterInterface.getRowDimension() : matrixParameterInterface.getColumnDimension();
        int n4 = matrixParameterInterface.getRowDimension();
        int n5 = bl ? n3 * n : n;
        for (int i = 0; i < n3; ++i) {
            double d3;
            double d4 = d3 = bl ? matrixParameterInterface.getParameterValue(i, n) : matrixParameterInterface.getParameterValue(n, i);
            if (!Double.isNaN(d3) && !this.missing[n5]) {
                d += d3;
                d2 += d3 * d3;
                ++n2;
            }
            n5 += bl ? 1 : n4;
        }
        MeanVariance meanVariance = new MeanVariance();
        meanVariance.mean = d / (double)n2;
        meanVariance.variance = d2 / (double)n2 - meanVariance.mean * meanVariance.mean;
        meanVariance.count = n2;
        return meanVariance;
    }

    private class MeanVariance {
        double mean;
        double variance;
        int count;

        private MeanVariance() {
        }
    }
}

