/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.operators;

import dr.evolution.tree.MutableTreeModel;
import dr.evolution.tree.NodeRef;
import dr.evomodel.continuous.AbstractMultivariateTraitLikelihood;
import dr.inference.operators.AbstractAdaptableOperator;
import dr.inference.operators.AdaptationMode;
import dr.inference.operators.MCMCOperator;
import dr.math.MathUtils;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

public class DiscretizedLocationOperator
extends AbstractAdaptableOperator {
    public static final String GIBBS_OPERATOR = "discretizedLocationOperator";
    public static final String INTERNAL_ONLY = "onlyInternalNodes";
    public static final String DISK = "neighborhoodSize";
    public static final String RANDOMIZE = "randomize";
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        private XMLSyntaxRule[] rules = new XMLSyntaxRule[]{AttributeRule.newDoubleRule("weight"), AttributeRule.newBooleanRule("autoOptimize", true), AttributeRule.newBooleanRule("onlyInternalNodes", true), new ElementRule(AbstractMultivariateTraitLikelihood.class), AttributeRule.newIntegerRule("neighborhoodSize", true), AttributeRule.newBooleanRule("randomize", true)};

        @Override
        public String getParserName() {
            return DiscretizedLocationOperator.GIBBS_OPERATOR;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            AdaptationMode adaptationMode = AdaptationMode.parseMode(xMLObject);
            double d = xMLObject.getDoubleAttribute("weight");
            boolean bl = xMLObject.getAttribute(DiscretizedLocationOperator.INTERNAL_ONLY, true);
            int n = xMLObject.getAttribute(DiscretizedLocationOperator.DISK, 4);
            AbstractMultivariateTraitLikelihood abstractMultivariateTraitLikelihood = (AbstractMultivariateTraitLikelihood)xMLObject.getChild(AbstractMultivariateTraitLikelihood.class);
            DiscretizedLocationOperator discretizedLocationOperator = new DiscretizedLocationOperator(abstractMultivariateTraitLikelihood, bl, n, adaptationMode);
            discretizedLocationOperator.setWeight(d);
            boolean bl2 = xMLObject.getAttribute(DiscretizedLocationOperator.RANDOMIZE, false);
            if (bl2) {
                discretizedLocationOperator.randomizeNodes();
            }
            return discretizedLocationOperator;
        }

        @Override
        public String getParserDescription() {
            return "This element returns a multivariate Gibbs operator on traits for possible all nodes.";
        }

        @Override
        public Class getReturnType() {
            return MCMCOperator.class;
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }
    };
    private Map<Point2D, List<WeightedPoint2D>> nearestNeighborMap;
    private Set<Point2D> allLocations;
    private final MutableTreeModel treeModel;
    private String traitName;
    private double autoOptimize;
    private boolean onlyInternalNodes = true;
    private int disk = 4;
    private Point2D savedPt;

    public DiscretizedLocationOperator(AbstractMultivariateTraitLikelihood abstractMultivariateTraitLikelihood, boolean bl, int n, AdaptationMode adaptationMode) {
        super(adaptationMode, 0.5);
        this.treeModel = abstractMultivariateTraitLikelihood.getTreeModel();
        this.traitName = abstractMultivariateTraitLikelihood.getTraitName();
        this.onlyInternalNodes = bl;
        this.allLocations = this.makeLocationList();
        this.nearestNeighborMap = this.makeNearestNeighborMap();
        this.disk = n;
        this.autoOptimize = this.convertToAutoOptimizeValue(n);
        if (n > this.allLocations.size() - 2) {
            throw new RuntimeException("Neighborhood size is too large");
        }
        this.printInfo();
    }

    private Map<Point2D, List<WeightedPoint2D>> makeNearestNeighborMap() {
        HashMap<Point2D, List<WeightedPoint2D>> hashMap = new HashMap<Point2D, List<WeightedPoint2D>>();
        for (Point2D point2D : this.allLocations) {
            ArrayList<WeightedPoint2D> arrayList = new ArrayList<WeightedPoint2D>();
            for (Point2D point2D2 : this.allLocations) {
                double d = point2D.distance(point2D2);
                if (!(d > 0.0)) continue;
                arrayList.add(new WeightedPoint2D(point2D2.getX(), point2D2.getY(), d));
            }
            Collections.sort(arrayList);
            hashMap.put(point2D, arrayList);
        }
        return hashMap;
    }

    private void recursivelySetTrait(NodeRef nodeRef, double[] dArray, NodeRef nodeRef2) {
        this.treeModel.setMultivariateTrait(nodeRef, this.traitName, dArray);
        for (int i = 0; i < this.treeModel.getChildCount(nodeRef); ++i) {
            NodeRef nodeRef3 = this.treeModel.getChild(nodeRef, i);
            if (nodeRef3 == nodeRef2 || this.treeModel.getBranchLength(nodeRef3) != 0.0) continue;
            this.recursivelySetTrait(nodeRef3, dArray, nodeRef);
        }
        if (!this.treeModel.isRoot(nodeRef) && this.treeModel.getBranchLength(nodeRef) == 0.0) {
            this.recursivelySetTrait(this.treeModel.getParent(nodeRef), dArray, nodeRef);
        }
    }

    public void randomizeNodes() {
        ArrayList<Point2D> arrayList = new ArrayList<Point2D>();
        arrayList.addAll(this.allLocations);
        for (int i = 0; i < this.treeModel.getInternalNodeCount(); ++i) {
            NodeRef nodeRef = this.treeModel.getInternalNode(i);
            double[] dArray = this.treeModel.getMultivariateNodeTrait(nodeRef, this.traitName);
            Point2D point2D = (Point2D)arrayList.get(MathUtils.nextInt(arrayList.size()));
            dArray[0] = point2D.getX();
            dArray[1] = point2D.getY();
            this.recursivelySetTrait(nodeRef, dArray, null);
        }
        System.err.println("Done with randomization");
    }

    private void printInfo() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\nCreating a discretized location sampler:\n");
        stringBuffer.append("\tTip count: " + this.treeModel.getExternalNodeCount() + "\n");
        stringBuffer.append("\tUnique locations: " + this.allLocations.size() + "\n");
        stringBuffer.append("\tNeighborhood size: " + this.disk + "\n");
        Logger.getLogger("dr.evomodel.operators").info(stringBuffer.toString());
    }

    private Set<Point2D> makeLocationList() {
        HashSet<Point2D> hashSet = new HashSet<Point2D>();
        for (int i = 0; i < this.treeModel.getExternalNodeCount(); ++i) {
            NodeRef nodeRef = this.treeModel.getExternalNode(i);
            double[] dArray = this.treeModel.getMultivariateNodeTrait(nodeRef, this.traitName);
            Point2D.Double double_ = new Point2D.Double(dArray[0], dArray[1]);
            if (hashSet.contains(double_)) continue;
            hashSet.add(double_);
            this.savedPt = double_;
        }
        return hashSet;
    }

    @Override
    public double doOperation() {
        NodeRef nodeRef = this.onlyInternalNodes ? this.treeModel.getInternalNode(MathUtils.nextInt(this.treeModel.getInternalNodeCount())) : this.treeModel.getNode(MathUtils.nextInt(this.treeModel.getNodeCount()));
        double[] dArray = this.treeModel.getMultivariateNodeTrait(nodeRef, this.traitName);
        Point2D.Double double_ = new Point2D.Double(dArray[0], dArray[1]);
        List<WeightedPoint2D> list = this.nearestNeighborMap.get(double_);
        if (list == null) {
            throw new RuntimeException("Node location outside allowable values: " + double_);
        }
        Point2D point2D = list.get(MathUtils.nextInt(this.convertFromAutoOptimizeValue(this.autoOptimize)));
        dArray[0] = point2D.getX();
        dArray[1] = point2D.getY();
        this.recursivelySetTrait(nodeRef, dArray, null);
        return 0.0;
    }

    private int convertFromAutoOptimizeValue(double d) {
        return 1 + (int)Math.exp(this.autoOptimize);
    }

    private double convertToAutoOptimizeValue(int n) {
        return Math.log(n - 1);
    }

    @Override
    protected double getAdaptableParameterValue() {
        return this.autoOptimize;
    }

    @Override
    public void setAdaptableParameterValue(double d) {
        this.autoOptimize = d;
    }

    @Override
    public double getRawParameter() {
        return this.convertFromAutoOptimizeValue(this.autoOptimize);
    }

    @Override
    public String getAdaptableParameterName() {
        return null;
    }

    @Override
    public final String getPerformanceSuggestion() {
        return "I have no idea.";
    }

    @Override
    public String getOperatorName() {
        return GIBBS_OPERATOR;
    }

    public class WeightedPoint2D
    extends Point2D.Double
    implements Comparable {
        public double weight;

        public WeightedPoint2D(double d, double d2, double d3) {
            super(d, d2);
            this.weight = d3;
        }

        public int compareTo(Object object) {
            WeightedPoint2D weightedPoint2D = (WeightedPoint2D)object;
            if (this.weight > weightedPoint2D.weight) {
                return 1;
            }
            if (this.weight < weightedPoint2D.weight) {
                return -1;
            }
            return 0;
        }

        @Override
        public String toString() {
            return super.toString() + "(" + this.weight + ")";
        }
    }
}

