/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.operators;

import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;
import dr.evomodel.tree.TreeModel;
import dr.inference.model.Parameter;
import dr.inference.operators.AbstractAdaptableOperator;
import dr.inference.operators.AdaptationMode;
import dr.inference.operators.MCMCOperator;
import dr.math.MathUtils;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

@Deprecated
public class NodeHeightScaleOperator
extends AbstractAdaptableOperator {
    public static final String NODE_HEIGHT_SCALE_OPERATOR = "nodeHeightScaleOperator";
    public static final String SCALE_FACTOR = "scaleFactor";
    public static final String SCALE_ALL = "scaleAll";
    private final TreeModel tree;
    private final boolean scaleAll;
    Set<Double> tipDates = new TreeSet<Double>();
    private final Map<Double, Integer> intervals = new TreeMap<Double, Integer>();
    private Parameter nodeHeightParameter;
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        private final XMLSyntaxRule[] rules = new XMLSyntaxRule[]{AttributeRule.newDoubleRule("scaleFactor"), AttributeRule.newDoubleRule("weight"), AttributeRule.newBooleanRule("scaleAll", true), AttributeRule.newBooleanRule("autoOptimize", true), new ElementRule(TreeModel.class)};

        @Override
        public String getParserName() {
            return NodeHeightScaleOperator.NODE_HEIGHT_SCALE_OPERATOR;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            AdaptationMode adaptationMode = AdaptationMode.parseMode(xMLObject);
            double d = xMLObject.getDoubleAttribute("weight");
            double d2 = xMLObject.getDoubleAttribute(NodeHeightScaleOperator.SCALE_FACTOR);
            boolean bl = xMLObject.getBooleanAttribute(NodeHeightScaleOperator.SCALE_ALL);
            if (d2 <= 0.0 || d2 >= 1.0) {
                throw new XMLParseException("scaleFactor must be between 0.0 and 1.0");
            }
            TreeModel treeModel = (TreeModel)xMLObject.getChild(TreeModel.class);
            NodeHeightScaleOperator nodeHeightScaleOperator = new NodeHeightScaleOperator(treeModel, d2, bl, adaptationMode);
            nodeHeightScaleOperator.setWeight(d);
            return nodeHeightScaleOperator;
        }

        @Override
        public String getParserDescription() {
            return "This element returns a nodeHeightScale operator on a given tree.";
        }

        @Override
        public Class getReturnType() {
            return MCMCOperator.class;
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }
    };
    private double scaleFactor = 0.5;

    public NodeHeightScaleOperator(TreeModel treeModel, double d, boolean bl, AdaptationMode adaptationMode) {
        super(adaptationMode);
        this.scaleFactor = d;
        this.scaleAll = bl;
        this.tree = treeModel;
        for (int i = 0; i < treeModel.getExternalNodeCount(); ++i) {
            double d2 = treeModel.getNodeHeight(treeModel.getExternalNode(i));
            this.tipDates.add(d2);
        }
    }

    @Override
    public final double doOperation() {
        double d = this.scaleFactor + MathUtils.nextDouble() * (1.0 / this.scaleFactor - this.scaleFactor);
        ArrayList arrayList = new ArrayList();
        double d2 = 0.0;
        if (!this.scaleAll) {
            int n = MathUtils.nextInt(this.tree.getInternalNodeCount());
            NodeRef nodeRef = this.tree.getNode(n);
            double d3 = this.tree.getNodeHeight(nodeRef);
            double d4 = d3 * d;
            this.tree.setNodeHeight(nodeRef, d4);
            d2 = this.getJacobian(nodeRef);
        }
        d2 = (double)(arrayList.size() - 2) * Math.log(d);
        return d2;
    }

    private double getJacobian(NodeRef nodeRef) {
        this.intervals.clear();
        for (Double d : this.tipDates) {
            this.intervals.put(d, 0);
        }
        this.traverse(this.tree, nodeRef);
        double d = 0.0;
        for (Double d2 : this.intervals.keySet()) {
            double d3 = this.tree.getNodeHeight(this.tree.getRoot()) - d2;
            int n = this.intervals.get(d2);
            d += this.logFactorial(n) - (double)n * Math.log(d3);
        }
        return d;
    }

    private double logFactorial(int n) {
        if (n == 0) {
            return 0.0;
        }
        double d = 0.0;
        for (int i = n; i > 0; --i) {
            d += Math.log(i);
        }
        return d;
    }

    private Double traverse(Tree tree, NodeRef nodeRef) {
        Double d;
        if (tree.isExternal(nodeRef)) {
            d = tree.getNodeHeight(nodeRef);
            if (!this.intervals.keySet().contains(d)) {
                throw new RuntimeException("Tip date not found");
            }
        } else {
            Double d2 = this.traverse(tree, tree.getChild(nodeRef, 0));
            Double d3 = this.traverse(tree, tree.getChild(nodeRef, 1));
            Double d4 = d = d2 > d3 ? d2 : d3;
            if (!tree.isRoot(nodeRef)) {
                this.intervals.put(d, this.intervals.get(d) + 1);
            }
        }
        return d;
    }

    void cleanupOperation(double d, double d2) {
    }

    @Override
    public final String getOperatorName() {
        return "nodeHeightScale";
    }

    @Override
    protected double getAdaptableParameterValue() {
        return Math.log(1.0 / this.scaleFactor - 1.0);
    }

    @Override
    public void setAdaptableParameterValue(double d) {
        this.scaleFactor = 1.0 / (Math.exp(d) + 1.0);
    }

    @Override
    public double getRawParameter() {
        return this.scaleFactor;
    }

    public double getScaleFactor() {
        return this.scaleFactor;
    }

    @Override
    public String getAdaptableParameterName() {
        return SCALE_FACTOR;
    }

    public String toString() {
        return "nodeHeightScaleOperator( [" + this.scaleFactor + ", " + 1.0 / this.scaleFactor + "]";
    }
}

