/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.operators;

import dr.inference.model.Parameter;
import dr.inference.operators.RandomWalkIntegerOperator;
import dr.math.MathUtils;

public class RandomWalkIntegerNodeHeightWeightedOperator
extends RandomWalkIntegerOperator {
    private Parameter internalNodeHeights;

    public RandomWalkIntegerNodeHeightWeightedOperator(Parameter parameter, int n, double d, Parameter parameter2) {
        super(parameter, n, d);
        this.internalNodeHeights = parameter2;
    }

    @Override
    public double doOperation() {
        int n = MathUtils.randomChoicePDF(this.internalNodeHeights.getParameterValues());
        int n2 = this.calculateNewValue(n);
        this.parameter.setValue(n, n2);
        return 0.0;
    }

    @Override
    public String getOperatorName() {
        return "randomWalkIntegerNodeHeightWeighted(" + this.parameter.getId() + ")";
    }

    @Override
    public double getTargetAcceptanceProbability() {
        return 0.234;
    }

    @Override
    public double getMinimumAcceptanceLevel() {
        return 0.1;
    }

    @Override
    public double getMaximumAcceptanceLevel() {
        return 0.4;
    }

    @Override
    public double getMinimumGoodAcceptanceLevel() {
        return 0.2;
    }

    @Override
    public double getMaximumGoodAcceptanceLevel() {
        return 0.3;
    }

    @Override
    public String toString() {
        return "randomWalkIntegerNodeHeightWeightedOperator(" + this.parameter.getId() + ", " + this.windowSize + ", " + this.getWeight() + ")";
    }
}

