/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.operators;

import dr.evolution.tree.NodeRef;
import dr.evolution.util.Taxon;
import dr.evomodel.tree.TreeModel;
import dr.inference.model.Bounds;
import dr.inference.model.Parameter;
import dr.inference.operators.UniformOperator;
import dr.math.MathUtils;

public class UniformTipFromPrecisionOperator
extends UniformOperator {
    private final TreeModel tree;
    private final Taxon taxon;

    public UniformTipFromPrecisionOperator(Parameter parameter, double d, Taxon taxon, TreeModel treeModel) {
        this(parameter, d, taxon, treeModel, null, null);
    }

    public UniformTipFromPrecisionOperator(Parameter parameter, double d, Taxon taxon, TreeModel treeModel, Double d2, Double d3) {
        super(parameter, d, d2, d3);
        this.tree = treeModel;
        this.taxon = taxon;
        if (parameter.getDimension() != 1) {
            throw new RuntimeException("UniformTipFromPrecision operator only valid for a single tip.");
        }
        if (!parameter.getParameterName().contains(taxon.toString())) {
            throw new RuntimeException("Mismatch between parameter and taxon names in UniformTipFromPrecision.");
        }
    }

    @Override
    public final double doOperation() {
        Bounds<Double> bounds = this.parameter.getBounds();
        NodeRef nodeRef = this.tree.getExternalNode(this.tree.getTaxonIndex(this.taxon));
        double d = this.tree.getNodeHeight(this.tree.getParent(nodeRef));
        double d2 = this.lowerBound == null ? bounds.getLowerLimit(0) : Math.max(bounds.getLowerLimit(0), this.lowerBound);
        double d3 = Math.min(d, this.upperBound == null ? bounds.getUpperLimit(0) : Math.min(bounds.getUpperLimit(0), this.upperBound));
        double d4 = MathUtils.nextDouble() * (d3 - d2) + d2;
        this.parameter.setParameterValue(0, d4);
        return 0.0;
    }

    @Override
    public final String getOperatorName() {
        return "uniformTipFromPrecision(" + this.parameter.getParameterName() + ")";
    }

    @Override
    public String toString() {
        return "uniformTipFromPrecisionOperator(" + this.parameter.getParameterName() + ")";
    }
}

