/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.substmodel;

import dr.evomodel.substmodel.aminoacid.EmpiricalAminoAcidModel;
import dr.inference.model.DesignMatrix;
import dr.inference.model.Parameter;
import java.util.List;

public class AminoAcidMixture
extends DesignMatrix {
    public AminoAcidMixture(List<EmpiricalAminoAcidModel> list) {
        super(AminoAcidMixture.getName(list), AminoAcidMixture.getParameters(list), false);
        if (this.anyRatesAreZero(list)) {
            throw new RuntimeException("AminoAcidMixtureModel cannot be used for rate matrices which have entries which are 0.0.");
        }
    }

    private static String getName(List<EmpiricalAminoAcidModel> list) {
        StringBuilder stringBuilder = new StringBuilder("designMatrix");
        for (EmpiricalAminoAcidModel empiricalAminoAcidModel : list) {
            String string = empiricalAminoAcidModel.getId();
            if (string == null || string.length() <= 0) continue;
            stringBuilder.append(".").append(string);
        }
        return stringBuilder.toString();
    }

    private static Parameter[] getParameters(List<EmpiricalAminoAcidModel> list) {
        Parameter[] parameterArray = new Parameter[list.size()];
        for (int i = 0; i < parameterArray.length; ++i) {
            EmpiricalAminoAcidModel empiricalAminoAcidModel = list.get(i);
            double[] dArray = empiricalAminoAcidModel.getEmpiricalRateMatrix().getEmpiricalRates();
            double[] dArray2 = new double[2 * dArray.length];
            for (int j = 0; j < dArray.length; ++j) {
                double d = Math.log(dArray[j]);
                dArray2[dArray.length + j] = d;
                dArray2[j] = d;
            }
            parameterArray[i] = new Parameter.Default(dArray2);
        }
        return parameterArray;
    }

    private boolean anyRatesAreZero(List<EmpiricalAminoAcidModel> list) {
        boolean bl = false;
        for (int i = 0; i < list.size(); ++i) {
            EmpiricalAminoAcidModel empiricalAminoAcidModel = list.get(i);
            double[] dArray = empiricalAminoAcidModel.getEmpiricalRateMatrix().getEmpiricalRates();
            for (int j = 0; j < dArray.length; ++j) {
                if (!(dArray[j] < Double.MIN_VALUE)) continue;
                bl = true;
            }
        }
        return bl;
    }
}

