/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.tree;

import dr.evolution.util.Taxon;
import dr.inference.model.Statistic;

public class AgeStatistic
extends Statistic.Abstract {
    private Statistic heightStatistic = null;
    private final double mostRecentTipTime;
    private final boolean isBackwards;

    public AgeStatistic(String string, Statistic statistic) {
        super(string);
        this.heightStatistic = statistic;
        if (Taxon.getMostRecentDate() != null) {
            this.isBackwards = Taxon.getMostRecentDate().isBackwards();
            this.mostRecentTipTime = Taxon.getMostRecentDate().getAbsoluteTimeValue();
        } else {
            this.mostRecentTipTime = Double.NaN;
            this.isBackwards = false;
        }
    }

    @Override
    public int getDimension() {
        return 1;
    }

    @Override
    public double getStatisticValue(int n) {
        if (!Double.isNaN(this.mostRecentTipTime)) {
            if (this.isBackwards) {
                return this.mostRecentTipTime + this.heightStatistic.getStatisticValue(n);
            }
            return this.mostRecentTipTime - this.heightStatistic.getStatisticValue(n);
        }
        return Double.NaN;
    }
}

