/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.treedatalikelihood.discrete;

import dr.evomodel.substmodel.FrequencyModel;
import dr.evomodel.substmodel.GlmSubstitutionModel;
import dr.evomodel.substmodel.SubstitutionModel;
import dr.evomodel.treedatalikelihood.BeagleDataLikelihoodDelegate;
import dr.evomodel.treedatalikelihood.TreeDataLikelihood;
import dr.evomodel.treedatalikelihood.discrete.AbstractLogAdditiveSubstitutionModelGradient;
import dr.inference.loggers.LogColumn;
import dr.inference.model.Parameter;
import dr.util.Citation;
import dr.util.Transform;
import java.util.List;

public class CtmcFrequencyModelGradient
extends AbstractLogAdditiveSubstitutionModelGradient {
    private final FrequencyModel frequencyModel;

    public CtmcFrequencyModelGradient(String string, TreeDataLikelihood treeDataLikelihood, BeagleDataLikelihoodDelegate beagleDataLikelihoodDelegate, GlmSubstitutionModel glmSubstitutionModel) {
        super(string, treeDataLikelihood, beagleDataLikelihoodDelegate, glmSubstitutionModel, AbstractLogAdditiveSubstitutionModelGradient.ApproximationMode.FIRST_ORDER);
        List<SubstitutionModel> list = beagleDataLikelihoodDelegate.getBranchModel().getSubstitutionModels();
        this.frequencyModel = beagleDataLikelihoodDelegate.getBranchModel().getRootFrequencyModel();
        for (SubstitutionModel substitutionModel : list) {
            if (this.frequencyModel == substitutionModel.getFrequencyModel()) continue;
            throw new RuntimeException("Not yet implemented");
        }
    }

    @Override
    protected double preProcessNormalization(double[] dArray, double[] dArray2, boolean bl) {
        double d = 0.0;
        if (bl) {
            for (int i = 0; i < this.stateCount; ++i) {
                for (int j = 0; j < this.stateCount; ++j) {
                    int n = i * this.stateCount + j;
                    d += dArray[n] * dArray2[n];
                }
            }
        }
        return d;
    }

    @Override
    double processSingleGradientDimension(int n, double[] dArray, double[] dArray2, double[] dArray3, boolean bl, double d, double d2, Transform transform, boolean bl2) {
        int n2;
        int n3;
        double d3 = 0.0;
        for (n3 = 0; n3 < this.stateCount; ++n3) {
            n2 = n3 * this.stateCount + n3;
            int n4 = n3 * this.stateCount + n;
            d3 += (dArray[n4] - dArray[n2]) * dArray2[n4];
        }
        if (bl) {
            for (n3 = 0; n3 < this.stateCount; ++n3) {
                n2 = n3 * this.stateCount + n;
                d3 -= dArray2[n2] * dArray3[n] * d;
            }
        }
        return d3;
    }

    @Override
    public Parameter getParameter() {
        return this.frequencyModel.getFrequencyParameter();
    }

    @Override
    public LogColumn[] getColumns() {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public Citation.Category getCategory() {
        return Citation.Category.SUBSTITUTION_MODELS;
    }

    @Override
    public String getDescription() {
        return null;
    }

    @Override
    public List<Citation> getCitations() {
        return null;
    }
}

