/*
 * Decompiled with CFR 0.152.
 */
package dr.evoxml;

import dr.evolution.alignment.PatternList;
import dr.evolution.distance.DistanceMatrix;
import dr.evolution.distance.F84DistanceMatrix;
import dr.evolution.distance.JukesCantorDistanceMatrix;
import dr.evolution.distance.SMMDistanceMatrix;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.ElementRule;
import dr.xml.StringAttributeRule;
import dr.xml.XMLObject;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import java.util.logging.Logger;

public class DistanceMatrixParser
extends AbstractXMLObjectParser {
    public static final String DISTANCE_MATRIX = "distanceMatrix";
    public static final String CORRECTION = "correction";
    private final XMLSyntaxRule[] rules = new XMLSyntaxRule[]{new StringAttributeRule("correction", "The type of distance correction used", new String[]{"none", "JC", "F84", "SMM"}, false), new ElementRule(PatternList.class)};

    @Override
    public String getParserName() {
        return DISTANCE_MATRIX;
    }

    @Override
    public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
        PatternList patternList = (PatternList)xMLObject.getChild(PatternList.class);
        DistanceMatrix distanceMatrix = null;
        String string = xMLObject.getStringAttribute(CORRECTION);
        if (string.equals("JC")) {
            Logger.getLogger("dr.evoxml").info("Creating Jukes-Cantor distance matrix");
            distanceMatrix = new JukesCantorDistanceMatrix(patternList);
        } else if (string.equals("F84")) {
            Logger.getLogger("dr.evoxml").info("Creating F84 distance matrix");
            distanceMatrix = new F84DistanceMatrix(patternList);
        } else if (string.equals("SMM")) {
            Logger.getLogger("dr.evoxml").info("Creating SMM distance matrix");
            distanceMatrix = new SMMDistanceMatrix(patternList);
        } else {
            distanceMatrix = new DistanceMatrix(patternList);
        }
        return distanceMatrix;
    }

    @Override
    public XMLSyntaxRule[] getSyntaxRules() {
        return this.rules;
    }

    @Override
    public String getParserDescription() {
        return "Constructs a distance matrix from a pattern list or alignment";
    }

    @Override
    public Class getReturnType() {
        return DistanceMatrix.class;
    }
}

