/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.distribution;

import dr.inference.distribution.ParametricDistributionModel;
import dr.inference.model.AbstractModel;
import dr.inference.model.GradientProvider;
import dr.inference.model.HessianProvider;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import dr.math.UnivariateFunction;
import dr.math.distributions.ExponentialDistribution;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ExponentialDistributionModel
extends AbstractModel
implements ParametricDistributionModel,
GradientProvider,
HessianProvider {
    public static final String EXPONENTIAL_DISTRIBUTION_MODEL = "exponentialDistributionModel";
    private final UnivariateFunction pdfFunction = new UnivariateFunction(){

        @Override
        public final double evaluate(double d) {
            return ExponentialDistributionModel.this.pdf(d);
        }

        @Override
        public final double getLowerBound() {
            return ExponentialDistributionModel.this.offset;
        }

        @Override
        public final double getUpperBound() {
            return Double.POSITIVE_INFINITY;
        }
    };
    private Variable<Double> mean = null;
    private double offset = 0.0;

    public ExponentialDistributionModel(Variable<Double> variable) {
        this(variable, 0.0);
    }

    public ExponentialDistributionModel(Variable<Double> variable, double d) {
        super(EXPONENTIAL_DISTRIBUTION_MODEL);
        this.mean = variable;
        this.offset = d;
        this.addVariable(variable);
        variable.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, 0.0, 1));
    }

    @Override
    public double pdf(double d) {
        if (d < this.offset) {
            return 0.0;
        }
        return ExponentialDistribution.pdf(d - this.offset, 1.0 / this.getMean());
    }

    @Override
    public double logPdf(double d) {
        if (d < this.offset) {
            return Double.NEGATIVE_INFINITY;
        }
        return ExponentialDistribution.logPdf(d - this.offset, 1.0 / this.getMean());
    }

    @Override
    public double cdf(double d) {
        if (d < this.offset) {
            return 0.0;
        }
        return ExponentialDistribution.cdf(d - this.offset, 1.0 / this.getMean());
    }

    @Override
    public double quantile(double d) {
        return ExponentialDistribution.quantile(d, 1.0 / this.getMean()) + this.offset;
    }

    @Override
    public double mean() {
        return ExponentialDistribution.mean(1.0 / this.getMean()) + this.offset;
    }

    @Override
    public double variance() {
        return ExponentialDistribution.variance(1.0 / this.getMean());
    }

    @Override
    public final UnivariateFunction getProbabilityDensityFunction() {
        return this.pdfFunction;
    }

    @Override
    public double logPdf(double[] dArray) {
        return this.logPdf(dArray[0]);
    }

    @Override
    public Variable<Double> getLocationVariable() {
        return this.mean;
    }

    @Override
    public void handleModelChangedEvent(Model model, Object object, int n) {
    }

    @Override
    public void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
    }

    @Override
    protected void storeState() {
    }

    @Override
    protected void restoreState() {
    }

    @Override
    protected void acceptState() {
    }

    @Override
    public Element createElement(Document document) {
        throw new RuntimeException("Not implemented!");
    }

    private double getMean() {
        return this.mean.getValue(0);
    }

    @Override
    public int getDimension() {
        return 1;
    }

    @Override
    public double[] getDiagonalHessianLogDensity(Object object) {
        return this.getDerivativeLogDensity(object, DerivativeType.DIAGONAL_HESSIAN);
    }

    @Override
    public double[][] getHessianLogDensity(Object object) {
        double[] dArray = this.getDiagonalHessianLogDensity(object);
        double[][] dArray2 = new double[dArray.length][dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray2[i][i] = dArray[i];
        }
        return dArray2;
    }

    @Override
    public double[] getGradientLogDensity(Object object) {
        return this.getDerivativeLogDensity(object, DerivativeType.GRADIENT);
    }

    private double[] getDerivativeLogDensity(Object object, DerivativeType derivativeType) {
        double[] dArray = GradientProvider.toDoubleArray(object);
        double[] dArray2 = new double[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray2[i] = derivativeType.getDerivativeLogPdf(dArray[i] - this.offset, 1.0 / this.getMean());
        }
        return dArray2;
    }

    private static enum DerivativeType {
        GRADIENT("gradient"){

            @Override
            public double getDerivativeLogPdf(double d, double d2) {
                return ExponentialDistribution.gradLogPdf(d, d2);
            }
        }
        ,
        DIAGONAL_HESSIAN("diagonalHessian"){

            @Override
            public double getDerivativeLogPdf(double d, double d2) {
                return ExponentialDistribution.hessianLogPdf(d, d2);
            }
        };

        private String type;

        private DerivativeType(String string2) {
            this.type = string2;
        }

        public abstract double getDerivativeLogPdf(double var1, double var3);
    }
}

