/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.model;

import dr.inference.model.MatrixParameter;
import dr.inference.model.Parameter;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;

public class DecomposedMatrix
extends MatrixParameter {
    public static final String DIM = "dim";
    public static final String MATRIX_PARAMETER = "decomposedMatrix";
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        private XMLSyntaxRule[] rules = new XMLSyntaxRule[]{new ElementRule(Parameter.class), AttributeRule.newIntegerArrayRule("dim", false)};

        @Override
        public String getParserName() {
            return DecomposedMatrix.MATRIX_PARAMETER;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            Parameter parameter = (Parameter)xMLObject.getChild(Parameter.class);
            int n = xMLObject.getIntegerAttribute(DecomposedMatrix.DIM);
            if (n * (n + 1) / 2 != parameter.getDimension()) {
                throw new XMLParseException("Dim attribute and parameter dimension do not match");
            }
            return new DecomposedMatrix(DecomposedMatrix.MATRIX_PARAMETER, n, parameter);
        }

        @Override
        public String getParserDescription() {
            return "A diagonal matrix parameter constructed from its diagonals.";
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }

        @Override
        public Class getReturnType() {
            return DecomposedMatrix.class;
        }
    };
    private boolean compositionKnown = false;
    private Parameter decomposition;
    private int dim;
    private double[][] matrix;
    private double[][] savedMatrix;
    private static int[] index = new int[]{0, 1, 3, 6, 10, 15, 21, 28, 36};

    public DecomposedMatrix(String string) {
        super(string);
    }

    public DecomposedMatrix(String string, int n, Parameter parameter) {
        super(string);
        this.dim = n;
        this.decomposition = parameter;
        this.matrix = new double[n][n];
        this.savedMatrix = new double[n][n];
        this.composeMatrix();
        this.addParameter(parameter);
    }

    public void parameterChangedEvent(Parameter parameter, int n) {
        this.compositionKnown = false;
        this.fireParameterChangedEvent();
    }

    void composeMatrix() {
        double[] dArray = this.decomposition.getParameterValues();
        for (int i = 0; i < this.dim; ++i) {
            for (int j = i; j < this.dim; ++j) {
                this.matrix[i][j] = 0.0;
                for (int k = 0; k <= i; ++k) {
                    double[] dArray2 = this.matrix[i];
                    int n = j;
                    dArray2[n] = dArray2[n] + dArray[index[i] + k] * dArray[index[j] + k];
                }
                this.matrix[j][i] = this.matrix[i][j];
            }
        }
        this.compositionKnown = true;
    }

    @Override
    public int getDimension() {
        return this.dim * this.dim;
    }

    @Override
    protected void storeValues() {
        super.storeValues();
        for (int i = 0; i < this.dim; ++i) {
            System.arraycopy(this.matrix[i], 0, this.savedMatrix[i], 0, this.dim);
        }
    }

    @Override
    public double getParameterValue(int n) {
        int n2 = n / this.dim;
        int n3 = n - n2 * this.dim;
        return this.matrix[n2][n3];
    }

    @Override
    protected void restoreValues() {
        super.restoreValues();
        for (int i = 0; i < this.dim; ++i) {
            System.arraycopy(this.savedMatrix[i], 0, this.matrix[i], 0, this.dim);
        }
    }

    @Override
    public double getParameterValue(int n, int n2) {
        if (!this.compositionKnown) {
            this.composeMatrix();
        }
        return this.matrix[n][n2];
    }

    @Override
    public double[][] getParameterAsMatrix() {
        if (!this.compositionKnown) {
            this.composeMatrix();
        }
        return this.matrix;
    }

    @Override
    public int getColumnDimension() {
        return this.dim;
    }

    @Override
    public int getRowDimension() {
        return this.dim;
    }
}

