/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.model;

import dr.inference.model.CompoundParameter;
import dr.inference.model.MatrixParameterInterface;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class FastCompoundMatrixParameter
extends CompoundParameter
implements MatrixParameterInterface {
    private final List<MatrixParameterInterface> matrices;
    private final int nRows;
    private final int nColumns;
    private final int[] matrixIndex;
    private final int[] columnIndex;
    private boolean doPropagateChangeUp = true;
    private static final String FAST_COMPOUND_MATRIX_PARAMETER = "fastCompoundMatrixParameter";
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        private final XMLSyntaxRule[] rules = new XMLSyntaxRule[]{new ElementRule(MatrixParameterInterface.class, 1, Integer.MAX_VALUE)};

        @Override
        public String getParserName() {
            return FastCompoundMatrixParameter.FAST_COMPOUND_MATRIX_PARAMETER;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            ArrayList<MatrixParameterInterface> arrayList = new ArrayList<MatrixParameterInterface>();
            for (int i = 0; i < xMLObject.getChildCount(); ++i) {
                arrayList.add((MatrixParameterInterface)xMLObject.getChild(i));
            }
            String string = xMLObject.hasId() ? xMLObject.getId() : null;
            return new FastCompoundMatrixParameter(string, arrayList);
        }

        @Override
        public String getParserDescription() {
            return "A fast compound matrix parameter constructed from its component parameters.";
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }

        @Override
        public Class getReturnType() {
            return FastCompoundMatrixParameter.class;
        }
    };

    private FastCompoundMatrixParameter(String string, List<MatrixParameterInterface> list) {
        super(string);
        this.matrices = list;
        this.nRows = list.get(0).getRowDimension();
        int n = 0;
        for (MatrixParameterInterface matrixParameterInterface : list) {
            if (matrixParameterInterface.getRowDimension() != this.nRows) {
                throw new RuntimeException("Invalid row dimensions");
            }
            n += matrixParameterInterface.getColumnDimension();
        }
        this.nColumns = n;
        this.matrixIndex = new int[this.nColumns];
        this.columnIndex = new int[this.nColumns];
        int n2 = 0;
        for (int i = 0; i < list.size(); ++i) {
            MatrixParameterInterface matrixParameterInterface = list.get(i);
            int n3 = matrixParameterInterface.getColumnDimension();
            Arrays.fill(this.matrixIndex, n2, n2 + n3, i);
            for (int j = 0; j < n3; ++j) {
                this.columnIndex[n2 + j] = j;
            }
            n2 += n3;
        }
        for (MatrixParameterInterface matrixParameterInterface : list) {
            this.addParameter(matrixParameterInterface);
        }
    }

    @Override
    public void fireParameterChangedEvent() {
        this.fireParameterChangedEvent(-1, Variable.ChangeType.ALL_VALUES_CHANGED);
    }

    @Override
    public void fireParameterChangedEvent(int n, Variable.ChangeType changeType) {
        assert (n == -1);
        assert (changeType == Variable.ChangeType.ALL_VALUES_CHANGED);
        this.doPropagateChangeUp = false;
        for (MatrixParameterInterface matrixParameterInterface : this.matrices) {
            matrixParameterInterface.fireParameterChangedEvent();
        }
        this.doPropagateChangeUp = true;
        super.fireParameterChangedEvent(n, changeType);
    }

    @Override
    public void variableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
        assert (n == -1);
        assert (changeType == Variable.ChangeType.ALL_VALUES_CHANGED);
        if (this.doPropagateChangeUp) {
            this.fireParameterChangedEvent(-1, Variable.ChangeType.ALL_VALUES_CHANGED);
        }
    }

    @Override
    public Parameter getParameter(int n) {
        return this.matrices.get(this.matrixIndex[n]).getParameter(this.columnIndex[n]);
    }

    @Override
    public void setParameterValue(int n, int n2, double d) {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public void setParameterValueQuietly(int n, int n2, double d) {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public void setParameterValueNotifyChangedAll(int n, int n2, double d) {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public double[] getColumnValues(int n) {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public double[][] getParameterAsMatrix() {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public int getColumnDimension() {
        return this.nColumns;
    }

    @Override
    public int getRowDimension() {
        return this.nRows;
    }

    @Override
    public int getUniqueParameterCount() {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public Parameter getUniqueParameter(int n) {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public void copyParameterValues(double[] dArray, int n) {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public void setAllParameterValuesQuietly(double[] dArray, int n) {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public String toSymmetricString() {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public boolean isConstrainedSymmetric() {
        throw new RuntimeException("Not yet implemented");
    }
}

