/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.model;

import dr.inference.model.Parameter;
import dr.inference.model.Statistic;
import dr.stats.DiscreteStatistics;

public class PearsonCorrelation
extends Statistic.Abstract {
    Parameter X;
    Parameter Y;
    boolean log = false;

    public PearsonCorrelation(Parameter parameter, Parameter parameter2, boolean bl) {
        if (parameter.getDimension() != parameter2.getDimension()) {
            throw new IllegalArgumentException();
        }
        this.X = parameter;
        this.Y = parameter2;
        this.log = bl;
    }

    @Override
    public int getDimension() {
        return 1;
    }

    @Override
    public double getStatisticValue(int n) {
        double[] dArray = this.X.getParameterValues();
        double[] dArray2 = this.Y.getParameterValues();
        if (this.log) {
            for (int i = 0; i < dArray.length; ++i) {
                dArray[i] = Math.log(dArray[i]);
                dArray2[i] = Math.log(dArray2[i]);
            }
        }
        double d = DiscreteStatistics.mean(dArray);
        double d2 = DiscreteStatistics.mean(dArray2);
        double d3 = DiscreteStatistics.stdev(dArray);
        double d4 = DiscreteStatistics.stdev(dArray2);
        double d5 = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            double d6 = dArray[i] - d;
            double d7 = dArray2[i] - d2;
            d5 += d6 * d7;
        }
        d5 /= (double)this.X.getDimension();
        return d5 /= d3 * d4;
    }
}

