/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.operators.rejection;

import dr.inference.operators.rejection.AcceptCondition;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.XMLObject;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;

public class DescendingAndSpacedCondition
implements AcceptCondition {
    private final double spacing;
    private static final String DESCENDING_AND_SPACED = "descendingAndSpaced";
    private static final String SPACING = "spacing";
    public static AbstractXMLObjectParser PARSER = new AbstractXMLObjectParser(){

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            double d = xMLObject.getDoubleAttribute(DescendingAndSpacedCondition.SPACING);
            if (d < 0.0 || d > 1.0) {
                throw new XMLParseException("Attribute 'spacing' must be between 0 and 1.");
            }
            return new DescendingAndSpacedCondition(d);
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return new XMLSyntaxRule[]{AttributeRule.newDoubleRule(DescendingAndSpacedCondition.SPACING)};
        }

        @Override
        public String getParserDescription() {
            return "Condition requiring parameter to have descending absolute values with some minimum spacing.";
        }

        @Override
        public Class getReturnType() {
            return DescendingAndSpacedCondition.class;
        }

        @Override
        public String getParserName() {
            return DescendingAndSpacedCondition.DESCENDING_AND_SPACED;
        }
    };

    DescendingAndSpacedCondition(double d) {
        this.spacing = d;
    }

    @Override
    public boolean satisfiesCondition(double[] dArray) {
        for (int i = 1; i < dArray.length; ++i) {
            if (!(this.spacing * Math.abs(dArray[i - 1]) < Math.abs(dArray[i]))) continue;
            return false;
        }
        return true;
    }
}

