/*
 * Decompiled with CFR 0.152.
 */
package dr.oldevomodel.treelikelihood;

import dr.oldevomodel.treelikelihood.LikelihoodCore;
import java.math.BigDecimal;
import java.math.MathContext;

@Deprecated
public class ArbitraryPrecisionLikelihoodCore
implements LikelihoodCore {
    private MathContext precision;
    private int stateCount;
    private int nodeCount;
    private int patternCount;
    private int partialsSize;
    private int matrixSize;
    private int matrixCount;
    private boolean integrateCategories;
    private BigDecimal[][][] partials;
    private int[][] states;
    private BigDecimal[][][] matrices;
    private int[] currentMatricesIndices;
    private int[] storedMatricesIndices;
    private int[] currentPartialsIndices;
    private int[] storedPartialsIndices;

    public ArbitraryPrecisionLikelihoodCore(int n, int n2) {
        this.stateCount = n;
        this.precision = new MathContext(n2);
    }

    @Override
    public void initialize(int n, int n2, int n3, boolean bl) {
        this.nodeCount = n;
        this.patternCount = n2;
        this.matrixCount = n3;
        this.integrateCategories = bl;
        this.partialsSize = bl ? n2 * this.stateCount * n3 : n2 * this.stateCount;
        this.partials = new BigDecimal[2][n][];
        this.currentMatricesIndices = new int[n];
        this.storedMatricesIndices = new int[n];
        this.currentPartialsIndices = new int[n];
        this.storedPartialsIndices = new int[n];
        this.states = new int[n][];
        for (int i = 0; i < n; ++i) {
            this.partials[0][i] = null;
            this.partials[1][i] = null;
            this.states[i] = null;
        }
        this.matrixSize = this.stateCount * this.stateCount;
        this.matrices = new BigDecimal[2][n][n3 * this.matrixSize];
    }

    @Override
    public void finalize() throws Throwable {
        super.finalize();
        this.nodeCount = 0;
        this.patternCount = 0;
        this.matrixCount = 0;
        this.partials = null;
        this.currentPartialsIndices = null;
        this.storedPartialsIndices = null;
        this.states = null;
        this.matrices = null;
        this.currentMatricesIndices = null;
        this.storedMatricesIndices = null;
    }

    @Override
    public void createNodePartials(int n) {
        this.partials[0][n] = new BigDecimal[this.partialsSize];
        this.partials[1][n] = new BigDecimal[this.partialsSize];
    }

    @Override
    public void setNodePartials(int n, double[] dArray) {
        if (this.partials[0][n] == null) {
            this.createNodePartials(n);
        }
        if (dArray.length < this.partialsSize) {
            int n2 = 0;
            for (int i = 0; i < this.matrixCount; ++i) {
                for (int j = 0; j < dArray.length; ++j) {
                    this.partials[0][n][n2] = new BigDecimal(dArray[j], this.precision);
                    ++n2;
                }
            }
        } else {
            for (int i = 0; i < dArray.length; ++i) {
                this.partials[0][n][i] = new BigDecimal(dArray[i], this.precision);
            }
        }
    }

    @Override
    public void createNodeStates(int n) {
        this.states[n] = new int[this.patternCount];
    }

    @Override
    public void setNodeStates(int n, int[] nArray) {
        if (this.states[n] == null) {
            this.createNodeStates(n);
        }
        System.arraycopy(nArray, 0, this.states[n], 0, this.patternCount);
    }

    public void getNodeStates(int n, int[] nArray) {
        System.arraycopy(this.states[n], 0, nArray, 0, this.patternCount);
    }

    @Override
    public void setNodeMatrixForUpdate(int n) {
        this.currentMatricesIndices[n] = 1 - this.currentMatricesIndices[n];
    }

    @Override
    public void setNodeMatrix(int n, int n2, double[] dArray) {
        for (int i = 0; i < this.matrixSize; ++i) {
            this.matrices[this.currentMatricesIndices[n]][n][n2 * this.matrixSize + i] = new BigDecimal(dArray[i], this.precision);
        }
    }

    public void getNodeMatrix(int n, int n2, double[] dArray) {
        for (int i = 0; i < this.matrixSize; ++i) {
            dArray[i] = this.matrices[this.currentMatricesIndices[n]][n][n2 * this.matrixSize + i].doubleValue();
        }
    }

    @Override
    public void setNodePartialsForUpdate(int n) {
        this.currentPartialsIndices[n] = 1 - this.currentPartialsIndices[n];
    }

    @Override
    public void setCurrentNodePartials(int n, double[] dArray) {
        throw new UnsupportedOperationException("setCurrentNodePartials is not supported by ArbitraryPrecisionLikelihoodCore");
    }

    @Override
    public void calculatePartials(int n, int n2, int n3) {
        if (this.states[n] != null) {
            if (this.states[n2] != null) {
                this.calculateStatesStatesPruning(this.states[n], this.matrices[this.currentMatricesIndices[n]][n], this.states[n2], this.matrices[this.currentMatricesIndices[n2]][n2], this.partials[this.currentPartialsIndices[n3]][n3]);
            } else {
                this.calculateStatesPartialsPruning(this.states[n], this.matrices[this.currentMatricesIndices[n]][n], this.partials[this.currentPartialsIndices[n2]][n2], this.matrices[this.currentMatricesIndices[n2]][n2], this.partials[this.currentPartialsIndices[n3]][n3]);
            }
        } else if (this.states[n2] != null) {
            this.calculateStatesPartialsPruning(this.states[n2], this.matrices[this.currentMatricesIndices[n2]][n2], this.partials[this.currentPartialsIndices[n]][n], this.matrices[this.currentMatricesIndices[n]][n], this.partials[this.currentPartialsIndices[n3]][n3]);
        } else {
            this.calculatePartialsPartialsPruning(this.partials[this.currentPartialsIndices[n]][n], this.matrices[this.currentMatricesIndices[n]][n], this.partials[this.currentPartialsIndices[n2]][n2], this.matrices[this.currentMatricesIndices[n2]][n2], this.partials[this.currentPartialsIndices[n3]][n3]);
        }
    }

    private void calculateStatesStatesPruning(int[] nArray, BigDecimal[] bigDecimalArray, int[] nArray2, BigDecimal[] bigDecimalArray2, BigDecimal[] bigDecimalArray3) {
        int n = 0;
        for (int i = 0; i < this.matrixCount; ++i) {
            for (int j = 0; j < this.patternCount; ++j) {
                int n2;
                int n3 = nArray[j];
                int n4 = nArray2[j];
                int n5 = i * this.matrixSize;
                if (n3 < this.stateCount && n4 < this.stateCount) {
                    for (n2 = 0; n2 < this.stateCount; ++n2) {
                        bigDecimalArray3[n] = bigDecimalArray[n5 + n3].multiply(bigDecimalArray2[n5 + n4], this.precision);
                        ++n;
                        n5 += this.stateCount;
                    }
                    continue;
                }
                if (n3 < this.stateCount) {
                    for (n2 = 0; n2 < this.stateCount; ++n2) {
                        bigDecimalArray3[n] = bigDecimalArray[n5 + n3];
                        ++n;
                        n5 += this.stateCount;
                    }
                    continue;
                }
                if (n4 < this.stateCount) {
                    for (n2 = 0; n2 < this.stateCount; ++n2) {
                        bigDecimalArray3[n] = bigDecimalArray2[n5 + n4];
                        ++n;
                        n5 += this.stateCount;
                    }
                    continue;
                }
                for (n2 = 0; n2 < this.stateCount; ++n2) {
                    bigDecimalArray3[n] = BigDecimal.ONE;
                    ++n;
                }
            }
        }
    }

    private void calculateStatesPartialsPruning(int[] nArray, BigDecimal[] bigDecimalArray, BigDecimal[] bigDecimalArray2, BigDecimal[] bigDecimalArray3, BigDecimal[] bigDecimalArray4) {
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < this.matrixCount; ++i) {
            for (int j = 0; j < this.patternCount; ++j) {
                int n3;
                BigDecimal bigDecimal;
                int n4;
                int n5 = nArray[j];
                int n6 = i * this.matrixSize;
                if (n5 < this.stateCount) {
                    for (n4 = 0; n4 < this.stateCount; ++n4) {
                        BigDecimal bigDecimal2 = bigDecimalArray[n6 + n5];
                        bigDecimal = BigDecimal.ZERO;
                        for (n3 = 0; n3 < this.stateCount; ++n3) {
                            bigDecimal = bigDecimal.add(bigDecimalArray3[n6].multiply(bigDecimalArray2[n2 + n3], this.precision), this.precision);
                            ++n6;
                        }
                        bigDecimalArray4[n] = bigDecimal2.multiply(bigDecimal, this.precision);
                        ++n;
                    }
                    n2 += this.stateCount;
                    continue;
                }
                for (n4 = 0; n4 < this.stateCount; ++n4) {
                    bigDecimal = BigDecimal.ZERO;
                    for (n3 = 0; n3 < this.stateCount; ++n3) {
                        bigDecimal = bigDecimal.add(bigDecimalArray3[n6].multiply(bigDecimalArray2[n2 + n3], this.precision), this.precision);
                        ++n6;
                    }
                    bigDecimalArray4[n] = bigDecimal;
                    ++n;
                }
                n2 += this.stateCount;
            }
        }
    }

    private void calculatePartialsPartialsPruning(BigDecimal[] bigDecimalArray, BigDecimal[] bigDecimalArray2, BigDecimal[] bigDecimalArray3, BigDecimal[] bigDecimalArray4, BigDecimal[] bigDecimalArray5) {
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < this.matrixCount; ++i) {
            for (int j = 0; j < this.patternCount; ++j) {
                int n3 = i * this.matrixSize;
                for (int k = 0; k < this.stateCount; ++k) {
                    BigDecimal bigDecimal;
                    BigDecimal bigDecimal2 = bigDecimal = BigDecimal.ZERO;
                    for (int i2 = 0; i2 < this.stateCount; ++i2) {
                        bigDecimal2 = bigDecimal2.add(bigDecimalArray2[n3].multiply(bigDecimalArray[n2 + i2], this.precision), this.precision);
                        bigDecimal = bigDecimal.add(bigDecimalArray4[n3].multiply(bigDecimalArray3[n2 + i2], this.precision), this.precision);
                        ++n3;
                    }
                    bigDecimalArray5[n] = bigDecimal2.multiply(bigDecimal, this.precision);
                    ++n;
                }
                n2 += this.stateCount;
            }
        }
    }

    @Override
    public void calculatePartials(int n, int n2, int n3, int[] nArray) {
        throw new UnsupportedOperationException("calculatePartials(int nodeIndex1, int nodeIndex2, int nodeIndex3, int[] matrixMap) is not implemented in this likelihood core");
    }

    @Override
    public void integratePartials(int n, double[] dArray, double[] dArray2) {
        throw new UnsupportedOperationException("integratePartials(int nodeIndex, double[] proportions, double[] outPartials) is not implemented in this likelihood core");
    }

    public void integratePartials(int n, double[] dArray, BigDecimal[] bigDecimalArray) {
        BigDecimal[] bigDecimalArray2 = new BigDecimal[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            bigDecimalArray2[i] = new BigDecimal(dArray[i], this.precision);
        }
        this.calculateIntegratePartials(this.partials[this.currentPartialsIndices[n]][n], bigDecimalArray2, bigDecimalArray);
    }

    private void calculateIntegratePartials(BigDecimal[] bigDecimalArray, BigDecimal[] bigDecimalArray2, BigDecimal[] bigDecimalArray3) {
        int n;
        int n2;
        int n3 = 0;
        int n4 = 0;
        for (n2 = 0; n2 < this.patternCount; ++n2) {
            for (n = 0; n < this.stateCount; ++n) {
                bigDecimalArray3[n3] = bigDecimalArray[n4].multiply(bigDecimalArray2[0], this.precision);
                ++n3;
                ++n4;
            }
        }
        for (n2 = 1; n2 < this.matrixCount; ++n2) {
            n3 = 0;
            for (n = 0; n < this.patternCount; ++n) {
                for (int i = 0; i < this.stateCount; ++i) {
                    bigDecimalArray3[n3] = bigDecimalArray3[n3].add(bigDecimalArray[n4].multiply(bigDecimalArray2[n2], this.precision), this.precision);
                    ++n3;
                    ++n4;
                }
            }
        }
    }

    public void calculateLogLikelihoods(BigDecimal[] bigDecimalArray, double[] dArray, double[] dArray2) {
        int n;
        BigDecimal[] bigDecimalArray2 = new BigDecimal[dArray.length];
        for (n = 0; n < bigDecimalArray2.length; ++n) {
            bigDecimalArray2[n] = new BigDecimal(dArray[n], this.precision);
        }
        n = 0;
        for (int i = 0; i < this.patternCount; ++i) {
            BigDecimal bigDecimal = BigDecimal.ZERO;
            for (int j = 0; j < this.stateCount; ++j) {
                bigDecimal = bigDecimal.add(bigDecimalArray2[j].multiply(bigDecimalArray[n], this.precision), this.precision);
                ++n;
            }
            double d = bigDecimal.scale();
            double d2 = bigDecimal.unscaledValue().doubleValue();
            dArray2[i] = Math.log(d2) - d * Math.log(10.0);
        }
    }

    @Override
    public void calculateLogLikelihoods(double[] dArray, double[] dArray2, double[] dArray3) {
        throw new UnsupportedOperationException("calculateLogLikelihoods(double[] partials, double[] frequencies, double[] outLogLikelihoods) is not implemented in this likelihood core");
    }

    @Override
    public void setUseScaling(boolean bl) {
    }

    @Override
    public double getLogScalingFactor(int n) {
        return 0.0;
    }

    @Override
    public boolean arePartialsRescaled() {
        return false;
    }

    @Override
    public void getLogScalingFactors(int n, double[] dArray) {
        throw new RuntimeException("Not yet implemented.");
    }

    @Override
    public void getPartials(int n, double[] dArray) {
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = this.partials[this.currentPartialsIndices[n]][n][i].doubleValue();
        }
    }

    @Override
    public void storeState() {
        System.arraycopy(this.currentMatricesIndices, 0, this.storedMatricesIndices, 0, this.nodeCount);
        System.arraycopy(this.currentPartialsIndices, 0, this.storedPartialsIndices, 0, this.nodeCount);
    }

    @Override
    public void restoreState() {
        int[] nArray = this.currentMatricesIndices;
        this.currentMatricesIndices = this.storedMatricesIndices;
        this.storedMatricesIndices = nArray;
        int[] nArray2 = this.currentPartialsIndices;
        this.currentPartialsIndices = this.storedPartialsIndices;
        this.storedPartialsIndices = nArray2;
    }

    public void checkScaling() {
    }
}

