/*
 * Decompiled with CFR 0.152.
 */
package dr.xml;

import dr.util.Property;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.ElementRule;
import dr.xml.StringAttributeRule;
import dr.xml.XMLObject;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;

public class PropertyParser
extends AbstractXMLObjectParser {
    private XMLSyntaxRule[] rules = new XMLSyntaxRule[]{new StringAttributeRule("name", "name of the property", "length"), new ElementRule(Object.class)};

    @Override
    public String getParserName() {
        return "property";
    }

    @Override
    public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
        Property property;
        Object object = xMLObject.getChild(0);
        String string = xMLObject.getStringAttribute("name");
        if (xMLObject.hasAttribute("index")) {
            int n = xMLObject.getIntegerAttribute("index");
            property = new Property(object, string, n);
        } else if (xMLObject.hasAttribute("label")) {
            String string2 = xMLObject.getStringAttribute("label");
            property = new Property(object, string, string2);
        } else {
            property = new Property(object, string);
        }
        if (property.getGetter() == null) {
            throw new XMLParseException("unknown property, " + string + ", for object, " + object + ", in property element");
        }
        return property;
    }

    @Override
    public String getParserDescription() {
        return "This element returns an object representing the named property of the given child object.";
    }

    @Override
    public Class getReturnType() {
        return Object.class;
    }

    @Override
    public XMLSyntaxRule[] getSyntaxRules() {
        return this.rules;
    }
}

