/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Discretizers.UniformFrequency_Discretizer;

import java.util.Vector;
import keel.Algorithms.Discretizers.Basic.Discretizer;
import keel.Algorithms.Genetic_Rule_Learning.Globals.Parameters;
import keel.Algorithms.Genetic_Rule_Learning.Globals.Rand;

public class UniformFrequencyDiscretizer
extends Discretizer {
    double numInt;

    public UniformFrequencyDiscretizer(int _numInt) {
        this.numInt = _numInt > 0 ? (double)_numInt : (Parameters.numInstances / 100 > Parameters.numClasses ? (double)(Parameters.numInstances / 100) : (double)Parameters.numClasses);
    }

    @Override
    protected Vector discretizeAttribute(int attribute, int[] values, int begin, int end) {
        double quota = (double)(end - begin + 1) / this.numInt;
        double dBound = 0.0;
        int oldBound = 0;
        Vector<Double> cp = new Vector<Double>();
        int i = 0;
        while ((double)i < this.numInt - 1.0) {
            int iBound = (int)Math.round(dBound += quota);
            if (iBound > oldBound) {
                if (this.realValues[attribute][values[iBound - 1]] != this.realValues[attribute][values[iBound]]) {
                    double cutPoint = (this.realValues[attribute][values[iBound - 1]] + this.realValues[attribute][values[iBound]]) / 2.0;
                    cp.addElement(new Double(cutPoint));
                } else {
                    double val = this.realValues[attribute][values[iBound]];
                    int numFW = 1;
                    while (iBound + numFW <= end && this.realValues[attribute][values[iBound + numFW]] == val) {
                        ++numFW;
                    }
                    if (iBound + numFW > end) {
                        numFW = end - begin + 2;
                    }
                    int numBW = 1;
                    while (iBound - numBW > oldBound && this.realValues[attribute][values[iBound - numBW]] == val) {
                        ++numBW;
                    }
                    if (iBound - numBW == oldBound) {
                        numBW = end - begin + 2;
                    }
                    if (numFW < numBW) {
                        iBound += numFW;
                    } else if (numBW < numFW) {
                        iBound -= numBW;
                    } else {
                        if (numFW == end - begin + 2) {
                            return cp;
                        }
                        if (Rand.getReal() < 0.5) {
                            iBound += numFW;
                        } else {
                            iBound -= numBW;
                            ++iBound;
                        }
                    }
                    double cutPoint = (this.realValues[attribute][values[iBound - 1]] + this.realValues[attribute][values[iBound]]) / 2.0;
                    cp.addElement(new Double(cutPoint));
                }
                oldBound = iBound;
            }
            ++i;
        }
        return cp;
    }
}

