/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jclec;

import java.util.List;
import junit.framework.TestCase;
import net.sourceforge.jclec.IEvaluator;
import net.sourceforge.jclec.IFitness;
import net.sourceforge.jclec.IIndividual;

public abstract class IEvaluatorTest<E extends IEvaluator>
extends TestCase {
    protected final Class<E> evaluatorClass;
    protected E evaluator;
    protected List<IIndividual> individuals;
    protected List<IFitness> expectedFitnesses;

    public IEvaluatorTest(Class<E> evaluatorClass, String name) {
        super(name);
        this.evaluatorClass = evaluatorClass;
    }

    public void testEvaluate() {
        this.createIndividuals();
        this.createExpectedFitnesses();
        this.evaluator.evaluate(this.individuals);
        int nofinds = this.individuals.size();
        int i = 0;
        while (i < nofinds) {
            IEvaluatorTest.assertEquals((Object)this.expectedFitnesses.get(i), (Object)this.individuals.get(i).getFitness());
            ++i;
        }
    }

    protected abstract void createIndividuals();

    protected abstract void createExpectedFitnesses();
}

