/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.UnsupervisedLearning.AssociationRules.FuzzyRuleLearning.Alcalaetal;

import java.util.ArrayList;
import java.util.Collections;
import keel.Algorithms.UnsupervisedLearning.AssociationRules.FuzzyRuleLearning.Alcalaetal.AssociationRule;
import keel.Algorithms.UnsupervisedLearning.AssociationRules.FuzzyRuleLearning.Alcalaetal.Chromosome;
import keel.Algorithms.UnsupervisedLearning.AssociationRules.FuzzyRuleLearning.Alcalaetal.FuzzyAttribute;
import keel.Algorithms.UnsupervisedLearning.AssociationRules.FuzzyRuleLearning.Alcalaetal.FuzzyDataset;
import keel.Algorithms.UnsupervisedLearning.AssociationRules.FuzzyRuleLearning.Alcalaetal.FuzzyRegion;
import keel.Algorithms.UnsupervisedLearning.AssociationRules.FuzzyRuleLearning.Alcalaetal.Gene;
import keel.Algorithms.UnsupervisedLearning.AssociationRules.FuzzyRuleLearning.Alcalaetal.Item;
import keel.Algorithms.UnsupervisedLearning.AssociationRules.FuzzyRuleLearning.Alcalaetal.Itemset;
import keel.Algorithms.UnsupervisedLearning.AssociationRules.FuzzyRuleLearning.Alcalaetal.myDataset;
import org.core.Randomize;

public class AlcalaetalProcess {
    private int nEvaluations;
    private int popSize;
    private int nBitsGene;
    private double phi;
    private double d;
    private int nFuzzyRegionsForNumericAttributes;
    private boolean useMaxForOneFrequentItemsets;
    private double minSupport;
    private double minConfidence;
    private myDataset dataset;
    private int nEval;
    private int nGenerations;
    private int evaluationStep;
    private String geneticLearningLog;
    private ArrayList<Integer> idOfAttributes;
    private double initialL;
    private ArrayList<FuzzyAttribute> uniformFuzzyAttributes;
    private ArrayList<FuzzyAttribute> bestFuzzyAttributes;
    private int countOneFrequentItemsets;
    private int countFrequentItemsets;
    private ArrayList<AssociationRule> associationRulesSet;
    private boolean[] coveredRecords;

    public AlcalaetalProcess(myDataset dataset, int nEvaluations, int popSize, int nBitsGene, double phi, double d, int nFuzzyRegionsForNumericAttributes, boolean useMaxForOneFrequentItemsets, double minSupport, double minConfidence) {
        this.nEvaluations = nEvaluations;
        this.popSize = popSize;
        this.nBitsGene = nBitsGene;
        this.phi = phi;
        this.d = d;
        this.nFuzzyRegionsForNumericAttributes = nFuzzyRegionsForNumericAttributes;
        this.useMaxForOneFrequentItemsets = useMaxForOneFrequentItemsets;
        this.minSupport = minSupport;
        this.minConfidence = minConfidence;
        this.dataset = dataset;
        this.nEval = 0;
        this.nGenerations = 0;
        this.evaluationStep = (int)Math.ceil((double)nEvaluations * 0.05);
        this.idOfAttributes = dataset.getIDsOfNumericAttributes();
        this.initialL = (double)(this.idOfAttributes.size() * nFuzzyRegionsForNumericAttributes * nBitsGene) / 4.0;
        this.countOneFrequentItemsets = 0;
        this.countFrequentItemsets = 0;
        this.associationRulesSet = new ArrayList();
        this.coveredRecords = new boolean[dataset.getnTrans()];
        for (int i = 0; i < this.coveredRecords.length; ++i) {
            this.coveredRecords[i] = false;
        }
    }

    public void run() {
        this.uniformFuzzyAttributes = this.buildInitialFuzzyAttributes();
        this.bestFuzzyAttributes = this.runGeneticAlgorithm();
        if (this.bestFuzzyAttributes == null) {
            this.bestFuzzyAttributes = new ArrayList();
        }
        this.addNominalFuzzyAttributes(this.uniformFuzzyAttributes);
        this.addNominalFuzzyAttributes(this.bestFuzzyAttributes);
        this.runFuzzyApriori(new FuzzyDataset(this.dataset, this.bestFuzzyAttributes));
    }

    public ArrayList<AssociationRule> getRulesSet() {
        return this.associationRulesSet;
    }

    public void printReport(ArrayList<AssociationRule> rules) {
        double avg_sup = 0.0;
        double avg_conf = 0.0;
        double avg_ant_length = 0.0;
        double avg_interest = 0.0;
        for (int r = 0; r < rules.size(); ++r) {
            AssociationRule ar = rules.get(r);
            avg_sup += ar.getRuleSupport();
            avg_conf += ar.getConfidence();
            avg_ant_length += (double)ar.getAntecedent().size();
            avg_interest += ar.getInterestingness();
        }
        System.out.println("\nNumber of Frequent Itemsets found: " + this.countFrequentItemsets);
        System.out.println("Number of Association Rules generated: " + rules.size());
        if (!rules.isEmpty()) {
            System.out.println("Average Support: " + avg_sup / (double)rules.size());
            System.out.println("Average Confidence: " + avg_conf / (double)rules.size());
            System.out.println("Average Antecedents Length: " + avg_ant_length / (double)rules.size());
            System.out.println("Number of Covered Records (%): " + 100.0 * (double)this.countCoveredRecords() / (double)this.dataset.getnTrans());
            System.out.println("Average Interestingness: " + avg_interest / (double)rules.size());
        }
    }

    public int getNumberOfOneFrequentItemsets() {
        return this.countOneFrequentItemsets;
    }

    public String getGeneticLearningLog() {
        return this.geneticLearningLog;
    }

    public ArrayList<FuzzyAttribute> getUniformFuzzyAttributes() {
        return this.uniformFuzzyAttributes;
    }

    public ArrayList<FuzzyAttribute> getAdjustedFuzzyAttributes() {
        return this.bestFuzzyAttributes;
    }

    private ArrayList<FuzzyAttribute> buildInitialFuzzyAttributes() {
        ArrayList<FuzzyAttribute> fuzzy_attributes = new ArrayList<FuzzyAttribute>();
        for (int attr = 0; attr < this.idOfAttributes.size(); ++attr) {
            int id_attr = this.idOfAttributes.get(attr);
            double rank = Math.abs(this.dataset.getMaxValue(id_attr) - this.dataset.getMinValue(id_attr));
            double mark = rank / ((double)this.nFuzzyRegionsForNumericAttributes - 1.0);
            FuzzyRegion[] fuzzy_regions = new FuzzyRegion[this.nFuzzyRegionsForNumericAttributes];
            for (int id_region = 0; id_region < this.nFuzzyRegionsForNumericAttributes; ++id_region) {
                fuzzy_regions[id_region] = new FuzzyRegion();
                double value = this.dataset.getMinValue(id_attr) + mark * (double)(id_region - 1);
                fuzzy_regions[id_region].setX0(this.setValue(value, this.dataset.getMaxValue(id_attr)));
                value = this.dataset.getMinValue(id_attr) + mark * (double)id_region;
                fuzzy_regions[id_region].setX1(this.setValue(value, this.dataset.getMaxValue(id_attr)));
                value = this.dataset.getMinValue(id_attr) + mark * (double)(id_region + 1);
                fuzzy_regions[id_region].setX3(this.setValue(value, this.dataset.getMaxValue(id_attr)));
                fuzzy_regions[id_region].setY(1.0);
                fuzzy_regions[id_region].setLabel("LABEL_" + id_region);
            }
            fuzzy_attributes.add(new FuzzyAttribute(id_attr, fuzzy_regions));
        }
        return fuzzy_attributes;
    }

    private double setValue(double val, double tope) {
        if (val > -1.0E-4 && val < 1.0E-4) {
            return 0.0;
        }
        if (val > tope - 1.0E-4 && val < tope + 1.0E-4) {
            return tope;
        }
        return val;
    }

    private void addNominalFuzzyAttributes(ArrayList<FuzzyAttribute> fuzzy_attributes) {
        for (int attr = 0; attr < this.dataset.getIDsOfNominalAttributes().size(); ++attr) {
            int id_attr = this.dataset.getIDsOfNominalAttributes().get(attr);
            FuzzyRegion[] fuzzy_regions = new FuzzyRegion[this.dataset.nValueNominal(id_attr)];
            for (int id_region = 0; id_region < fuzzy_regions.length; ++id_region) {
                fuzzy_regions[id_region] = new FuzzyRegion();
                fuzzy_regions[id_region].setX0(id_region - 1);
                fuzzy_regions[id_region].setX1(id_region);
                fuzzy_regions[id_region].setX3(id_region + 1);
                fuzzy_regions[id_region].setY(1.0);
                fuzzy_regions[id_region].setLabel(this.dataset.getNominalValue(id_attr, id_region));
            }
            fuzzy_attributes.add(new FuzzyAttribute(id_attr, fuzzy_regions));
        }
    }

    private ArrayList<FuzzyAttribute> runGeneticAlgorithm() {
        ArrayList<FuzzyAttribute> best_fuzzy_attribute = null;
        this.geneticLearningLog = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";
        this.geneticLearningLog = this.geneticLearningLog + "<genetic_learning>\n";
        if (!this.idOfAttributes.isEmpty()) {
            Chromosome old_best_chromosome;
            System.out.print("Initialing population... ");
            double l = this.initialL;
            int decrement = 1;
            ArrayList<Chromosome> current_pop = new ArrayList<Chromosome>();
            Chromosome best_chromosome = old_best_chromosome = this.buildInitialChromosome();
            this.initializePopulation(current_pop, best_chromosome);
            this.evaluate(current_pop, 0, this.popSize);
            System.out.println("done [Evaluations: " + this.nEval + "].");
            while (this.nEval < this.nEvaluations) {
                ++this.nGenerations;
                System.out.print("Computing Generation #" + this.nGenerations + "... ");
                ArrayList<Chromosome> old_pop = new ArrayList<Chromosome>(current_pop);
                this.crossover(current_pop, l);
                this.evaluate(current_pop, this.popSize, current_pop.size());
                best_chromosome = this.select(current_pop);
                if (best_chromosome.equals(old_best_chromosome)) {
                    l -= 1.0;
                } else {
                    decrement = 1;
                    old_best_chromosome = best_chromosome;
                }
                if (this.noNewChromosomes(current_pop, old_pop)) {
                    l -= (double)decrement;
                    if (best_chromosome.equals(old_best_chromosome)) {
                        decrement *= 2;
                    }
                }
                if (l < 0.0) {
                    this.initializePopulation(current_pop, best_chromosome);
                    this.evaluate(current_pop, 0, this.popSize);
                    l = this.initialL;
                    decrement = 1;
                }
                System.out.println("done [Evaluations: " + this.nEval + "].");
            }
            best_fuzzy_attribute = this.transformIntoFuzzyAttributes(best_chromosome);
        }
        this.geneticLearningLog = this.geneticLearningLog + "</genetic_learning>";
        return best_fuzzy_attribute;
    }

    private Chromosome buildInitialChromosome() {
        Gene[] genes = new Gene[this.idOfAttributes.size()];
        double[] displacements = new double[this.nFuzzyRegionsForNumericAttributes];
        for (int g = 0; g < genes.length; ++g) {
            for (int d = 0; d < displacements.length; ++d) {
                displacements[d] = 0.5;
            }
            genes[g] = new Gene(displacements);
        }
        return new Chromosome(genes);
    }

    private void initializePopulation(ArrayList<Chromosome> pop, Chromosome seed_chromosome) {
        pop.clear();
        pop.add(seed_chromosome);
        Gene[] genes = new Gene[this.idOfAttributes.size()];
        double[] displacements = new double[this.nFuzzyRegionsForNumericAttributes];
        for (int p = 1; p < this.popSize; ++p) {
            for (int g = 0; g < genes.length; ++g) {
                for (int d = 0; d < displacements.length; ++d) {
                    displacements[d] = Randomize.Rand();
                }
                genes[g] = new Gene(displacements);
            }
            pop.add(new Chromosome(genes));
        }
    }

    private void evaluate(ArrayList<Chromosome> pop, int start_index, int end_index) {
        for (int i = start_index; i < end_index; ++i) {
            this.evaluateFitness(pop.get(i));
        }
    }

    private Chromosome select(ArrayList<Chromosome> pop) {
        Collections.sort(pop);
        while (pop.size() > this.popSize) {
            pop.remove(this.popSize);
        }
        return pop.get(0);
    }

    private boolean noNewChromosomes(ArrayList<Chromosome> current_pop, ArrayList<Chromosome> old_pop) {
        return current_pop.containsAll(old_pop);
    }

    private void crossover(ArrayList<Chromosome> pop, double threshold) {
        int j;
        int i;
        int[] index_mating_pool = new int[pop.size()];
        for (i = 0; i < index_mating_pool.length; ++i) {
            index_mating_pool[i] = i;
        }
        for (i = 0; i < index_mating_pool.length; ++i) {
            j = Randomize.Randint(i, index_mating_pool.length);
            int aux = index_mating_pool[j];
            index_mating_pool[j] = index_mating_pool[i];
            index_mating_pool[i] = aux;
        }
        for (i = 0; i < index_mating_pool.length / 2; ++i) {
            Chromosome mom = pop.get(index_mating_pool[2 * i]);
            Chromosome dad = pop.get(index_mating_pool[2 * i + 1]);
            int total_length = this.idOfAttributes.size() * this.nFuzzyRegionsForNumericAttributes * this.nBitsGene;
            double hamming_distance = this.calculateHammingDistance(this.transformIntoGrayCode(mom), this.transformIntoGrayCode(dad), total_length);
            if (!(hamming_distance / 2.0 > threshold)) continue;
            Chromosome[] offsprings = this.pcBLX(mom, dad);
            for (j = 0; j < offsprings.length; ++j) {
                pop.add(offsprings[j]);
            }
        }
    }

    private int calculateHammingDistance(ArrayList<Boolean> bit_str1, ArrayList<Boolean> bit_str2, int length) {
        int dist = 0;
        for (int i = 0; i < length; ++i) {
            if (bit_str1.get(i) == bit_str2.get(i)) continue;
            ++dist;
        }
        return dist;
    }

    private ArrayList<Boolean> transformIntoGrayCode(Chromosome chr) {
        ArrayList<Boolean> bit_str = new ArrayList<Boolean>();
        double step = 1.0 / (Math.pow(2.0, this.nBitsGene) - 1.0);
        Gene[] genes = chr.getGenes();
        for (int g = 0; g < genes.length; ++g) {
            double[] displacements = genes[g].getDisplacements();
            for (int d = 0; d < displacements.length; ++d) {
                int num = (int)(displacements[d] / step + 0.5);
                boolean[] bin_num = this.toBinary(num, this.nBitsGene);
                boolean[] gray_num = this.toGray(bin_num);
                for (int b = 0; b < gray_num.length; ++b) {
                    bit_str.add(gray_num[b]);
                }
            }
        }
        return bit_str;
    }

    private boolean[] toBinary(int num, int n_bits) {
        boolean[] bin_num = new boolean[n_bits];
        for (int i = bin_num.length - 1; i >= 0; --i) {
            bin_num[i] = (num & 1) != 0;
            num >>= 1;
        }
        return bin_num;
    }

    private boolean[] toGray(boolean[] bin_num) {
        boolean last = false;
        boolean[] gray_num = new boolean[bin_num.length];
        for (int i = 0; i < gray_num.length; ++i) {
            gray_num[i] = bin_num[i] != last;
            last = bin_num[i];
        }
        return gray_num;
    }

    private Chromosome[] pcBLX(Chromosome mom, Chromosome dad) {
        Chromosome[] offsprings = new Chromosome[2];
        Gene[] mom_genes = mom.getGenes();
        Gene[] dad_genes = dad.getGenes();
        Gene[][] offsprings_genes = new Gene[2][mom_genes.length];
        for (int g = 0; g < mom_genes.length; ++g) {
            double[] mom_disp = mom_genes[g].getDisplacements();
            double[] dad_disp = dad_genes[g].getDisplacements();
            double[][] offsprings_disp = new double[2][mom_disp.length];
            for (int d = 0; d < mom_disp.length; ++d) {
                double amp = Math.abs(mom_disp[d] - dad_disp[d]);
                double l = Math.max(0.0, mom_disp[d] - amp * this.d);
                double u = Math.min(1.0, mom_disp[d] + amp * this.d);
                offsprings_disp[0][d] = Randomize.Randdouble(l, u);
                l = Math.max(0.0, dad_disp[d] - amp * this.d);
                u = Math.min(1.0, dad_disp[d] + amp * this.d);
                offsprings_disp[1][d] = Randomize.Randdouble(l, u);
            }
            offsprings_genes[0][g] = new Gene(offsprings_disp[0]);
            offsprings_genes[1][g] = new Gene(offsprings_disp[1]);
        }
        offsprings[0] = new Chromosome(offsprings_genes[0]);
        offsprings[1] = new Chromosome(offsprings_genes[1]);
        return offsprings;
    }

    private void evaluateFitness(Chromosome c) {
        int i;
        ArrayList<Itemset> one_frequent_itemsets = this.generateOneFrequentItemsets(new FuzzyDataset(this.dataset, this.transformIntoFuzzyAttributes(c)), false);
        int num_one_frequent_itemsets = one_frequent_itemsets.size();
        double sum_fuzzy_support = 0.0;
        for (i = 0; i < num_one_frequent_itemsets; ++i) {
            sum_fuzzy_support += one_frequent_itemsets.get(i).getSupport();
        }
        Gene[] genes = c.getGenes();
        double suitability = 0.0;
        for (i = 0; i < genes.length; ++i) {
            suitability += genes[i].calculateOverlapFactor(this.uniformFuzzyAttributes.get(i)) + 1.0;
        }
        double fitness = sum_fuzzy_support / suitability;
        c.setFitness(fitness);
        c.setSumFuzzySupport(sum_fuzzy_support);
        c.setSuitability(suitability);
        c.setNumOneFrequentItemsets(num_one_frequent_itemsets);
        ++this.nEval;
        if (this.nEval % this.evaluationStep == 0) {
            this.buildXMLRecord(fitness, sum_fuzzy_support, suitability, num_one_frequent_itemsets);
        }
    }

    private void buildXMLRecord(double fitness, double sum_fuzzy_support, double suitability, int num_one_frequent_itemsets) {
        this.geneticLearningLog = this.geneticLearningLog + "<log n_evaluations=\"" + this.nEval + "\" ";
        this.geneticLearningLog = this.geneticLearningLog + "n_generation=\"" + this.nGenerations + "\" ";
        this.geneticLearningLog = this.geneticLearningLog + "fitness=\"" + fitness + "\" ";
        this.geneticLearningLog = this.geneticLearningLog + "sum_fuzzy_support=\"" + sum_fuzzy_support + "\" ";
        this.geneticLearningLog = this.geneticLearningLog + "suitability=\"" + suitability + "\" ";
        this.geneticLearningLog = this.geneticLearningLog + "n_one_frequent_itemsets=\"" + num_one_frequent_itemsets + "\"/>\n";
    }

    private ArrayList<FuzzyAttribute> transformIntoFuzzyAttributes(Chromosome c) {
        ArrayList<FuzzyAttribute> fuzzy_attributes = new ArrayList<FuzzyAttribute>();
        Gene[] genes = c.getGenes();
        for (int g = 0; g < genes.length; ++g) {
            FuzzyRegion[] uniform_fuzzy_regions = this.uniformFuzzyAttributes.get(g).getFuzzyRegions();
            FuzzyRegion[] fuzzy_regions = new FuzzyRegion[uniform_fuzzy_regions.length];
            double[] displacements = genes[g].getDisplacements();
            for (int r = 0; r < fuzzy_regions.length; ++r) {
                double displacement = r == 0 ? (displacements[r] - 0.5) * (uniform_fuzzy_regions[r + 1].getX1() - uniform_fuzzy_regions[r].getX1()) : (r == fuzzy_regions.length - 1 ? (displacements[r] - 0.5) * (uniform_fuzzy_regions[r].getX1() - uniform_fuzzy_regions[r - 1].getX1()) : (displacements[r] - 0.5 < 0.0 ? (displacements[r] - 0.5) * (uniform_fuzzy_regions[r].getX1() - uniform_fuzzy_regions[r - 1].getX1()) : (displacements[r] - 0.5) * (uniform_fuzzy_regions[r + 1].getX1() - uniform_fuzzy_regions[r].getX1())));
                fuzzy_regions[r] = new FuzzyRegion();
                fuzzy_regions[r].setX0(uniform_fuzzy_regions[r].getX0() + displacement);
                fuzzy_regions[r].setX1(uniform_fuzzy_regions[r].getX1() + displacement);
                fuzzy_regions[r].setX3(uniform_fuzzy_regions[r].getX3() + displacement);
                fuzzy_regions[r].setY(uniform_fuzzy_regions[r].getY());
                fuzzy_regions[r].setLabel(uniform_fuzzy_regions[r].getLabel());
            }
            fuzzy_attributes.add(new FuzzyAttribute(this.idOfAttributes.get(g), fuzzy_regions));
        }
        return fuzzy_attributes;
    }

    private void runFuzzyApriori(FuzzyDataset fuzzyDataset) {
        int pass = 0;
        ArrayList<Itemset> current_frequent_itemsets = this.generateOneFrequentItemsets(fuzzyDataset, this.useMaxForOneFrequentItemsets);
        this.countFrequentItemsets = this.countOneFrequentItemsets = current_frequent_itemsets.size();
        System.out.println("\nPass: " + (pass + 1) + "; Total Frequent Itemsets: " + this.countFrequentItemsets);
        for (pass = 1; pass < this.dataset.getnVars() && current_frequent_itemsets.size() > 1; ++pass) {
            current_frequent_itemsets = this.generateCandidateItemsetsAndRules(fuzzyDataset, current_frequent_itemsets);
            this.countFrequentItemsets += current_frequent_itemsets.size();
            System.out.println("Pass: " + (pass + 1) + "; Total Frequent Itemsets: " + this.countFrequentItemsets + "; Total Association Rules: " + this.associationRulesSet.size());
        }
    }

    private ArrayList<Itemset> generateOneFrequentItemsets(FuzzyDataset fuzzyDataset, boolean use_max_for_one_frequent_itemsets) {
        int[] num_fuzzy_regions = fuzzyDataset.getNumberOfFuzzyRegions();
        ArrayList<Itemset> one_frequent_itemsets = new ArrayList<Itemset>();
        if (use_max_for_one_frequent_itemsets) {
            for (int id_attr = 0; id_attr < fuzzyDataset.getNumberOfFuzzyAttributes(); ++id_attr) {
                Itemset best_itemset = new Itemset();
                best_itemset.add(new Item(id_attr, 0));
                best_itemset.calculateSupport(fuzzyDataset);
                double max_support = best_itemset.getSupport();
                for (int id_region = 1; id_region < num_fuzzy_regions[id_attr]; ++id_region) {
                    Itemset itemset = new Itemset();
                    itemset.add(new Item(id_attr, id_region));
                    itemset.calculateSupport(fuzzyDataset);
                    if (!(itemset.getSupport() > max_support)) continue;
                    max_support = itemset.getSupport();
                    best_itemset = itemset;
                }
                if (!(max_support >= this.minSupport)) continue;
                one_frequent_itemsets.add(best_itemset);
            }
        } else {
            for (int id_attr = 0; id_attr < fuzzyDataset.getNumberOfFuzzyAttributes(); ++id_attr) {
                for (int id_region = 0; id_region < num_fuzzy_regions[id_attr]; ++id_region) {
                    Itemset itemset = new Itemset();
                    itemset.add(new Item(id_attr, id_region));
                    itemset.calculateSupport(fuzzyDataset);
                    if (!(itemset.getSupport() >= this.minSupport)) continue;
                    one_frequent_itemsets.add(itemset);
                }
            }
        }
        return one_frequent_itemsets;
    }

    private ArrayList<Itemset> generateCandidateItemsetsAndRules(FuzzyDataset fuzzyDataset, ArrayList<Itemset> curr_freq_itemsets) {
        int size = curr_freq_itemsets.size();
        ArrayList<Itemset> next_freq_itemsets = new ArrayList<Itemset>();
        for (int i = 0; i < size - 1; ++i) {
            Itemset i_itemset = curr_freq_itemsets.get(i);
            for (int j = i + 1; j < size; ++j) {
                Itemset j_itemset = curr_freq_itemsets.get(j);
                if (!this.isCombinable(i_itemset, j_itemset, curr_freq_itemsets)) continue;
                Itemset new_itemset = i_itemset.clone();
                new_itemset.add(j_itemset.get(j_itemset.size() - 1).clone());
                ArrayList<Integer> covered_tids = new_itemset.calculateSupport(fuzzyDataset);
                if (!(new_itemset.getSupport() >= this.minSupport)) continue;
                boolean generated_rules = this.generateRulesFromItemset(fuzzyDataset, new_itemset);
                if (generated_rules) {
                    this.markCoveredRecords(covered_tids);
                }
                next_freq_itemsets.add(new_itemset);
            }
        }
        return next_freq_itemsets;
    }

    private boolean generateRulesFromItemset(FuzzyDataset fuzzyDataset, Itemset curr_itemset) {
        boolean generated_rules = false;
        for (int i = 0; i < curr_itemset.size(); ++i) {
            Itemset antecedent = curr_itemset.clone();
            Item i_item = antecedent.remove(i);
            antecedent.calculateSupport(fuzzyDataset);
            double rule_sup = curr_itemset.getSupport();
            double ant_sup = antecedent.getSupport();
            double rule_conf = rule_sup / ant_sup;
            if (!(rule_conf >= this.minConfidence)) continue;
            Itemset consequent = new Itemset();
            consequent.add(i_item);
            consequent.calculateSupport(fuzzyDataset);
            double cons_sup = consequent.getSupport();
            double interest = rule_conf * (rule_sup / cons_sup) * (1.0 - rule_sup / (double)this.dataset.getnTrans());
            antecedent.changeIdAttr(fuzzyDataset);
            consequent.changeIdAttr(fuzzyDataset);
            this.associationRulesSet.add(new AssociationRule(antecedent, consequent, rule_sup, ant_sup, rule_conf, cons_sup, interest));
            if (generated_rules) continue;
            generated_rules = true;
        }
        return generated_rules;
    }

    private boolean isCombinable(Itemset i_itemset, Itemset j_itemset, ArrayList<Itemset> curr_freq_itemsets) {
        if (i_itemset.size() != j_itemset.size()) {
            return false;
        }
        Item i_item = i_itemset.get(i_itemset.size() - 1);
        Item j_item = j_itemset.get(i_itemset.size() - 1);
        if (i_item.getIDAttribute() >= j_item.getIDAttribute()) {
            return false;
        }
        for (int i = 0; i < i_itemset.size() - 1; ++i) {
            i_item = i_itemset.get(i);
            if (i_item.equals(j_item = j_itemset.get(i))) continue;
            return false;
        }
        Itemset itemset = i_itemset.clone();
        itemset.add(j_itemset.get(i_itemset.size() - 1).clone());
        return !this.pruning(itemset, curr_freq_itemsets);
    }

    private boolean pruning(Itemset itemset, ArrayList<Itemset> curr_freq_itemsets) {
        for (int i = 0; i < itemset.size() - 2; ++i) {
            Itemset sub = itemset.clone();
            sub.remove(i);
            if (this.existingIntoFrequentItemsets(sub, curr_freq_itemsets)) continue;
            return true;
        }
        return false;
    }

    private boolean existingIntoFrequentItemsets(Itemset itemset, ArrayList<Itemset> curr_freq_itemsets) {
        for (int i = 0; i < curr_freq_itemsets.size(); ++i) {
            Itemset its = curr_freq_itemsets.get(i);
            if (!its.equals(itemset)) continue;
            return true;
        }
        return false;
    }

    private void markCoveredRecords(ArrayList<Integer> covered_tids) {
        for (int i = 0; i < covered_tids.size(); ++i) {
            int t = covered_tids.get(i);
            if (this.coveredRecords[t]) continue;
            this.coveredRecords[t] = true;
        }
    }

    private int countCoveredRecords() {
        int cnt_covered_records = 0;
        for (int i = 0; i < this.coveredRecords.length; ++i) {
            if (!this.coveredRecords[i]) continue;
            ++cnt_covered_records;
        }
        return cnt_covered_records;
    }
}

