/*
 * Decompiled with CFR 0.152.
 */
package javolution.realtime;

import javolution.JavolutionError;
import javolution.lang.Reflection;
import javolution.realtime.Context;
import javolution.realtime.PoolContext;

public class HeapContext
extends Context {
    private static final Class CLASS = Reflection.getClass("javolution.realtime.HeapContext");

    public static HeapContext current() {
        Context context;
        if (context.inheritedPoolContext != null) {
            return null;
        }
        for (context = Context.current(); context != null; context = context.getOuter()) {
            if (!(context instanceof HeapContext)) continue;
            return (HeapContext)context;
        }
        throw new JavolutionError("No heap context or pool context");
    }

    public static void enter() {
        Context.enter(CLASS);
    }

    public static void exit() {
        Context.exit(CLASS);
    }

    protected void enterAction() {
        this.inheritedPoolContext = null;
        PoolContext poolContext = this.getOuter().inheritedPoolContext;
        if (poolContext != null) {
            poolContext.setInUsePoolsLocal(false);
        }
    }

    protected void exitAction() {
        PoolContext poolContext = this.getOuter().inheritedPoolContext;
        if (poolContext != null) {
            poolContext.setInUsePoolsLocal(true);
        }
    }
}

