/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.variables.impl;

import java.util.Arrays;
import java.util.Spliterator;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.chocosolver.solver.Cause;
import org.chocosolver.solver.ICause;
import org.chocosolver.solver.Model;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.propagation.PropagationEngine;
import org.chocosolver.solver.variables.BoolVar;
import org.chocosolver.solver.variables.IVariableMonitor;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.RealVar;
import org.chocosolver.solver.variables.SetVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.events.IEventType;
import org.chocosolver.solver.variables.impl.BipartiteList;
import org.chocosolver.solver.variables.impl.IBipartiteList;
import org.chocosolver.solver.variables.view.IView;
import org.chocosolver.util.iterators.EvtScheduler;
import org.chocosolver.util.tools.ArrayUtils;

public abstract class AbstractVariable
implements Variable {
    static final String MSG_REMOVE = "remove last value";
    protected static final String MSG_EMPTY = "empty domain";
    protected static final String MSG_INST = "the variable is already instantiated to another value";
    static final String MSG_UNKNOWN = "unknown value";
    static final String MSG_UPP = "the new upper bound is lesser than the current lower bound";
    static final String MSG_LOW = "the new lower bound is greater than the current upper bound";
    static final String MSG_BOUND = "new bounds are incorrect";
    private final int ID;
    protected final Model model;
    protected final String name;
    final IBipartiteList[] propagators;
    private int nbPropagators;
    private IView<?>[] views;
    private int[] idxInViews;
    private int vIdx;
    protected IVariableMonitor[] monitors;
    protected int mIdx;
    private final EvtScheduler<?> scheduler;
    private int instWI;
    private int mask;
    private ICause cause;
    public boolean scheduled;

    protected AbstractVariable(String name, Model model) {
        this.name = name;
        this.model = model;
        this.views = null;
        this.idxInViews = null;
        this.monitors = null;
        this.scheduler = this.createScheduler();
        int dsize = this.scheduler.select(0);
        this.propagators = new IBipartiteList[dsize + 1];
        for (int i = 0; i < dsize + 1; ++i) {
            this.propagators[i] = IBipartiteList.empty();
        }
        this.nbPropagators = 0;
        this.ID = this.model.nextId();
        this.model.associates(this);
        this.instWI = 0;
        this.scheduled = false;
    }

    protected abstract EvtScheduler<?> createScheduler();

    @Override
    public boolean isScheduled() {
        return this.scheduled;
    }

    @Override
    public void schedule() {
        this.scheduled = true;
    }

    @Override
    public void schedulePropagators(PropagationEngine engine) {
        if (this.mask > 0) {
            EvtScheduler<?> si = this.getEvtScheduler();
            si.init(this.mask);
            while (si.hasNext()) {
                int j = si.next();
                for (int i = si.next(); i < j; ++i) {
                    this.propagators[i].schedule(this.cause, engine, this.mask);
                }
            }
        }
        this.clearEvents();
    }

    @Override
    public void unschedule() {
        this.scheduled = false;
    }

    @Override
    public final int getId() {
        return this.ID;
    }

    @Override
    public final void link(Propagator<?> propagator, int idxInProp) {
        int i = this.scheduler.select(propagator.getPropagationConditions(idxInProp));
        ++this.nbPropagators;
        if (this.propagators[i] == IBipartiteList.EMPTY) {
            this.propagators[i] = new BipartiteList(this.model.getEnvironment());
        }
        propagator.setVIndices(idxInProp, this.propagators[i].add(propagator, idxInProp));
    }

    @Override
    public final void unlink(Propagator<?> propagator, int idxInProp) {
        int i = this.scheduler.select(propagator.getPropagationConditions(idxInProp));
        --this.nbPropagators;
        this.propagators[i].remove(propagator, idxInProp, this);
    }

    @Override
    public void swapOnPassivate(Propagator<?> propagator, int idxInProp) {
        int i = this.scheduler.select(propagator.getPropagationConditions(idxInProp));
        this.propagators[i].swap(propagator, idxInProp, this);
    }

    @Override
    public Stream<Propagator<?>> streamPropagators() {
        Spliterator it = new Spliterator<Propagator<?>>(){
            int c = 0;
            int i;
            {
                this.i = AbstractVariable.this.propagators[this.c].getFirst();
            }

            @Override
            public boolean tryAdvance(Consumer<? super Propagator<?>> action) {
                while (true) {
                    if (this.i < AbstractVariable.this.propagators[this.c].getLast()) {
                        action.accept(AbstractVariable.this.propagators[this.c].get(this.i++));
                        return true;
                    }
                    ++this.c;
                    if (this.c >= AbstractVariable.this.propagators.length) break;
                    this.i = AbstractVariable.this.propagators[this.c].getFirst();
                }
                return false;
            }

            @Override
            public Spliterator<Propagator<?>> trySplit() {
                return null;
            }

            @Override
            public long estimateSize() {
                return AbstractVariable.this.nbPropagators;
            }

            @Override
            public int characteristics() {
                return 4369;
            }
        };
        return StreamSupport.stream(it, false);
    }

    @Override
    public void forEachPropagator(BiConsumer<Variable, Propagator<?>> action) {
        int c = 0;
        int i = this.propagators[c].getFirst();
        do {
            if (i < this.propagators[c].getLast()) {
                action.accept(this, this.propagators[c].get(i++));
                continue;
            }
            if (++c >= this.propagators.length) continue;
            i = this.propagators[c].getFirst();
        } while (c < this.propagators.length);
    }

    @Override
    public final int getNbProps() {
        return this.nbPropagators;
    }

    @Override
    public int instantiationWorldIndex() {
        return this.isInstantiated() ? this.instWI : Integer.MAX_VALUE;
    }

    @Override
    public void recordWorldIndex() {
        this.instWI = this.model.getEnvironment().getWorldIndex();
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public void notifyPropagators(IEventType event, ICause cause) throws ContradictionException {
        assert (cause != null);
        if (this.isInstantiated()) {
            this.recordWorldIndex();
        }
        this.model.getSolver().getEngine().onVariableUpdate(this, event, cause);
        this.notifyMonitors(event);
        this.notifyViews(event, cause);
    }

    @Override
    public void notifyMonitors(IEventType event) throws ContradictionException {
        for (int i = this.mIdx - 1; i >= 0; --i) {
            this.monitors[i].onUpdate(this, event);
        }
    }

    @Override
    public void notifyViews(IEventType event, ICause cause) throws ContradictionException {
        assert (cause != null);
        if (cause == Cause.Null) {
            for (int i = this.vIdx - 1; i >= 0; --i) {
                this.views[i].notify(event, this.idxInViews[i]);
            }
        } else {
            for (int i = this.vIdx - 1; i >= 0; --i) {
                if (this.views[i] == cause) continue;
                this.views[i].notify(event, this.idxInViews[i]);
            }
        }
    }

    @Override
    public void addMonitor(IVariableMonitor<?> monitor) {
        if (this.monitors == null) {
            this.monitors = new IVariableMonitor[1];
        }
        if (this.model.getSettings().checkDeclaredMonitors()) {
            for (int i = 0; i < this.mIdx; ++i) {
                if (this.monitors[i] != monitor) continue;
                return;
            }
        }
        if (this.mIdx == this.monitors.length) {
            this.monitors = Arrays.copyOf(this.monitors, ArrayUtils.newBoundedSize(this.monitors.length, 16));
        }
        this.monitors[this.mIdx++] = monitor;
    }

    @Override
    public void removeMonitor(IVariableMonitor<?> monitor) {
        int i;
        for (i = this.mIdx - 1; i >= 0 && this.monitors[i] != monitor; --i) {
        }
        if (i < this.mIdx - 1) {
            System.arraycopy(this.monitors, i + 1, this.monitors, i, this.mIdx - (i + 1));
        }
        this.monitors[--this.mIdx] = null;
    }

    @Override
    public void subscribeView(IView<?> view, int idx) {
        if (this.views == null) {
            this.views = new IView[1];
            this.idxInViews = new int[1];
        }
        if (this.vIdx == this.views.length) {
            this.views = Arrays.copyOf(this.views, ArrayUtils.newBoundedSize(this.views.length, 16));
            this.idxInViews = Arrays.copyOf(this.idxInViews, ArrayUtils.newBoundedSize(this.idxInViews.length, 16));
        }
        this.views[this.vIdx] = view;
        this.idxInViews[this.vIdx] = idx;
        ++this.vIdx;
    }

    @Override
    public final void contradiction(ICause cause, String message) throws ContradictionException {
        assert (cause != null);
        this.model.getSolver().throwsException(cause, this, message);
    }

    @Override
    public final Model getModel() {
        return this.model;
    }

    @Override
    public int getNbViews() {
        return this.vIdx;
    }

    @Override
    public IView<?> getView(int idx) {
        return this.views[idx];
    }

    @Override
    public int compareTo(Variable o) {
        return this.getId() - o.getId();
    }

    public String toString() {
        return this.getName();
    }

    public final boolean isBool() {
        return (this.getTypeAndKind() & 0x3F8) == 24;
    }

    @Override
    public final boolean isAConstant() {
        return (this.getTypeAndKind() & 7) == 2;
    }

    @Override
    public final EvtScheduler<?> getEvtScheduler() {
        return this.scheduler;
    }

    @Override
    public IntVar asIntVar() {
        return (IntVar)((Object)this);
    }

    @Override
    public BoolVar asBoolVar() {
        return (BoolVar)((Object)this);
    }

    @Override
    public RealVar asRealVar() {
        return (RealVar)((Object)this);
    }

    @Override
    public SetVar asSetVar() {
        return (SetVar)((Object)this);
    }

    @Override
    public void storeEvents(int m, ICause cause) {
        assert (cause != null) : "an event's cause is not supposed to be null";
        if (this.cause == null) {
            this.cause = cause;
        } else if (this.cause != cause) {
            this.cause = Cause.Null;
        }
        this.mask |= m;
    }

    @Override
    public void clearEvents() {
        this.cause = null;
        this.mask = 0;
        this.unschedule();
    }

    @Override
    public int getMask() {
        return this.mask;
    }

    @Override
    public ICause getCause() {
        return this.cause;
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AbstractVariable)) {
            return false;
        }
        AbstractVariable that = (AbstractVariable)o;
        return this.ID == that.ID;
    }

    public final int hashCode() {
        return this.ID;
    }
}

