# Start of environment setup code
# The level of detail in the information messages
ve <- 2
# The name of the folder that will contain all the files. It will be created in
# the current directory. NULL implies tempdir will be used.
fn <- NULL
# The required files. They are default files that are part of the package
rf <- c("input.txt")
# An object of class EnvManager is created
em <- EnvManager$new(ve = ve)
# The required files are downloaded
ed <- em$setup_env(rf, fn)
# End of environment setup code

# The files to clean
fns <- c("train", "test", "validate")
# An object of class DataSampler is created
ds <- DataSampler$new(dir = ed, ve = ve)
# The train, test and validation files are generated
ds$generate_data(
    fn = "input.txt",
    percs = list(
        "train" = 0.8,
        "test" = 0.1,
        "validate" = 0.1
    )
)

# The test environment is removed. Comment the below line, so the files
# generated by the function can be viewed
em$td_env()
