% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scores_mh.R
\name{compute_mh_y_sup_sum}
\alias{compute_mh_y_sup_sum}
\title{Compute "7-Up Mania Inventory [Youth]: Sum"}
\usage{
compute_mh_y_sup_sum(
  data,
  name = "mh_y_sup_sum",
  max_na = 0,
  exclude = NULL,
  combine = TRUE
)
}
\arguments{
\item{data}{tbl. Data frame containing the columns to be summarized.}

\item{name}{character. Name of the summary score column.}

\item{max_na}{numeric, positive whole number. Number of missing items
allowed. \code{NULL} means no limit.}

\item{exclude}{character vector. Values to be excluded from the summary
score calculation.}

\item{combine}{logical. If \code{TRUE} (default), the summary score is
is appended as a new column to the input data frame. If \code{FALSE}, the
summary score is returned as a separate one-column data frame.}
}
\value{
tbl. see \code{combine}.
}
\description{
Computes the summary score \code{mh_y_sup_sum}
7-Up Mania Inventory [Youth]: Sum
\itemize{
\item \emph{Summarized variables:}
\itemize{
\item \code{mh_y_sup_001}
\item \code{mh_y_sup_002}
\item \code{mh_y_sup_003}
\item \code{mh_y_sup_004}
\item \code{mh_y_sup_005}
\item \code{mh_y_sup_006}
\item \code{mh_y_sup_007}
}
\item \emph{Excluded values:} none
\item \emph{Validation criterion:} none of 7 items missing
}
}
\examples{
\dontrun{
compute_mh_y_sup_sum(data) |>
  select(
    any_of(c("mh_y_sup_sum", vars_mh_y_sup))
  )
}
}
\seealso{
\code{\link[=compute_mh_y_sup_nm]{compute_mh_y_sup_nm()}}
}
