% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/train_val_split.R
\name{train_val_split_method2}
\alias{train_val_split_method2}
\title{Train-Validation Split by Accident Period Method 2}
\usage{
train_val_split_method2(df, tri.size, val_ratio, test = FALSE)
}
\arguments{
\item{df}{Claims Triangle and other information. \code{data.frame} format of
claims and related information for each cell. Dataframe will have columns
\code{origin} and \code{dev} as columns 1 and 2 respectively.}

\item{tri.size}{Triangle size.}

\item{val_ratio}{Value between 0 and 1 as the approximate size of validaiton
set.}

\item{test}{Returns the test set if \code{TRUE} .}
}
\value{
List containing \verb{$train}, \verb{$valid}, \verb{$test}, which should partition
the input \code{df}.
}
\description{
Function for training/validation splitting.
}
\details{
Approximates the validation set by defining the training set as the cells
below the function \eqn{((b^{1/a} - x^{1/a})^a)}. Where \eqn{b} is equal to
the triangle size and \eqn{a} is optimised to best fit \code{val_ratio}.

The training set is therefore cells outside of this period but within the
upper triangle. The test set is all observations in the lower triangle.

Note that accident period 1 and development period 1 will always be within
the training set.
}
\examples{

data("test_claims_dataset")

train_val <- train_val_split_method1(
    df = test_claims_dataset,
    tri.size = 40,
    val_ratio = 0.3,
    test = TRUE
)

}
\seealso{
\link[ADLP]{train_val_split}
}
