% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ahm.R
\name{mapping_function}
\alias{mapping_function}
\title{Mapping_function is a function to add the functional coefficients of major components in front of minor components terms}
\usage{
mapping_function(x, num_major = 3, dist_minor = C(2, 2, 1),
  mapping_type = c("power"), powerh = 0)
}
\arguments{
\item{x}{data.frame Note the column names of the x should be in the order of major components, minor components, and no interactions are needed.}

\item{num_major}{number of major components}

\item{dist_minor}{the allocation of number of minor components nested under major components}

\item{mapping_type}{the form of the coefficient function of major components in front of corresponding minor terms. Currently only support "power"}

\item{powerh}{the power parameter used for the power function}
}
\value{
data frame
}
\description{
Mapping_function is a function to add the functional coefficients of major components in front of minor components terms
}
\examples{
data("pringles_fat")
data_fat = pringles_fat
h_tmp = 1.3
x = data_fat[,c("c1","c2","c3","x11","x12","x21","x22")]
mapping_function(x=x, num_major=3, dist_minor=c(2,2,1), mapping_type = c("power"), powerh=0)
}
