% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/latlon2SA.R
\name{latlon2SA}
\alias{latlon2SA}
\title{Determine whether coordinates lie in a given statistical area.}
\usage{
latlon2SA(
  lat,
  lon,
  to = c("STE", "SA2", "SA1", "SA3", "SA4"),
  yr = c("2016", "2011"),
  return = c("v", "sp"),
  NAME = TRUE,
  .shapefile = NULL
)
}
\arguments{
\item{lat, lon}{Numeric vector representing coordinates in decimal degrees. Coordinates south of the equator have \code{lat < 0}.}

\item{to}{The statistical area to convert to.}

\item{yr}{The year of the statistical area.}

\item{return}{Whether to return an atomic vector \code{(v)} representing the shapefile for each point \code{lat, lon} or a spatial points object from package \code{sp}.}

\item{NAME}{(logical, default: \code{TRUE}) whether to use the name or number of the statistical area}

\item{.shapefile}{If specified, an arbitrary shapefile containing the statistical areas to locate.}
}
\value{
The statistical area that contains each point.
}
\description{
Determine whether coordinates lie in a given statistical area.
}
\examples{
latlon2SA(-35.3, 149.2, to = "STE", yr = "2016")
}
