% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/partition_and_normalize.R
\name{partition_and_normalize}
\alias{partition_and_normalize}
\title{Partition and Normalize}
\usage{
partition_and_normalize(
  x,
  y,
  x.test = NULL,
  y.test = NULL,
  family_column = NULL,
  split_by_family = FALSE,
  test_size = 0.3,
  better_smaller = TRUE
)
}
\arguments{
\item{x}{dataframe with the instances (rows) and its features (columns). It may also include a column with the family data.}

\item{y}{dataframe with the instances (rows) and the corresponding output (KPI) for each algorithm (columns).}

\item{x.test}{dataframe with the test features. It may also include a column with the family data. If NULL the algorithm will split x into training and test sets.}

\item{y.test}{dataframe with the test outputs. If NULL the algorithm will y into training and test sets.}

\item{family_column}{column number of x where each instance family is indicated. If given, adittional options for the training and set test splitting and the graphics are enabled.}

\item{split_by_family}{boolean indicating if we want to split sets keeping family proportions in case x.test and y.test are NULL. This option requires that option \code{family_column} is different from NULL.}

\item{test_size}{float with the segmentation proportion for the test dataframe. It must be a value between 0 and 1. Only needed when \code{x.test} and \code{y.test} are NULL.}

\item{better_smaller}{boolean that indicates whether the output (KPI) is better if smaller (TRUE) or larger (FALSE).}
}
\value{
A list is returned of class \code{as_data} containing:
\itemize{
\item \code{x.train} A data frame with the training features.
\item \code{y.train} A data frame with the training output.
\item \code{x.test} A data frame with the test features.
\item \code{y.test} A data frame with the test output.
\item \code{y.train.original} A vector with the original training output (without normalizing).
\item \code{y.test.original} A vector with the original test output (without normalizing).
\item \code{families.train} A data frame with the families of the training data.
\item \code{families.test} A data frame with the families of the test data.
}
}
\description{
Function that processes the input data splitting it into training and test sets and normalizes the outputs depending on the best instance performance. The user can bypass the partition into training and test set by passing the parameters \code{x.test} and \code{y.test}.
}
\examples{
data(branching)
data_obj <- partition_and_normalize(branching$x, branching$y, test_size = 0.3,
family_column = 1, split_by_family = TRUE)

}
