% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kinship_diagnostics.R
\name{kinship.diagnostics}
\alias{kinship.diagnostics}
\title{Reports summary statistics, plots and filter options for a given kinship matrix K}
\usage{
kinship.diagnostics(
  K = NULL,
  diagonal.thr.large = 1.2,
  diagonal.thr.small = 0.8,
  duplicate.thr = 0.95,
  clean.diagonal = FALSE,
  clean.duplicate = FALSE,
  plots = TRUE,
  sample.plot = 1,
  message = TRUE
)
}
\arguments{
\item{K}{Input of a kinship matrix in full format (\eqn{n \times n}) (default = \code{NULL}).}

\item{diagonal.thr.large}{A threshold value to flag large diagonal values (default = \code{1.2}).}

\item{diagonal.thr.small}{A threshold value to flag small diagonal values (default = \code{0.8}).}

\item{duplicate.thr}{A threshold value to flag possible duplicates. Any calculation larger than the
threshold based on
\eqn{\boldsymbol{k}_{i,i}\mathbin{/}\sqrt{\boldsymbol{k}_{i,i} \times \boldsymbol{k}_{j,j}}}
is identified as a duplicate (default = \code{0.95}).}

\item{clean.diagonal}{If \code{TRUE} returns a kinship matrix filtered by values smaller than
\code{diagonal.thr.large} and larger than \code{diagonal.thr.small} (default = \code{FALSE}).}

\item{clean.duplicate}{If \code{TRUE} return a kinship matrix without the flagged duplicate individuals.
All individuals involved are removed (default = \code{FALSE}).}

\item{plots}{If \code{TRUE} generates graphical output of the diagonal and off-diagonal
values of the kinship matrix (default = \code{TRUE}).}

\item{sample.plot}{A numeric value between 0 and 1 indicating the proportion
of the data points to be sampled for fast plotting of off-diagonal values.
Note that for proportions other than 1, the method is not exact and low
proportions are only recommended for large kinship matrices (default = \code{1}).}

\item{message}{If \code{TRUE} diagnostic messages are printed on screen (default = \code{TRUE}).}
}
\value{
A list with the following elements:
\itemize{
\item{\code{list.diagonal}: a data frame with the list of flagged large or small diagonal values.}
\item{\code{list.duplicate}: a data frame with the list of possible duplicates.}
\item{\code{clean.kinship}: output of kinship matrix filtered without the flagged diagonal
 and/or duplicate individuals.}
\item{\code{plot.diagonal}: histogram with the distribution of diagonal values from the kinship matrix.}
\item{\code{plot.offdiag}: histogram with the distribution of off-diagonal values from kinship matrix.}
}
}
\description{
It reports summary statistics, plots and allows for some filter options
for diagonal and off-diagonal elements for a given kinship matrix.
The input matrix can be a pedigree-based
relationship matrix \eqn{\boldsymbol{A}}, a genomic relationship matrix \eqn{\boldsymbol{G}} or a
hybrid relationship matrix \eqn{\boldsymbol{H}}.
Individual names should be assigned to \code{rownames} and \code{colnames}.
}
\examples{
# Get G matrix.
G <- G.matrix(M = geno.apple, method = "VanRaden")$G

# Diagnose G.
G_summary <- kinship.diagnostics(
 K = G,
 diagonal.thr.large = 1.3, diagonal.thr.small = 0.7, clean.diagonal = TRUE,
 duplicate.thr = 0.8, clean.duplicate = TRUE,
 sample.plot = 0.50)
ls(G_summary)
dim(G_summary$clean.kinship)
G_summary$clean.kinship[1:5, 1:5]
G_summary$list.duplicate
G_summary$list.diagonal
G_summary$plot.diag
G_summary$plot.offdiag

}
