% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim.R
\name{sim_path}
\alias{sim_path}
\title{Simulate the path of a time-inhomogeneous (semi-)Markov process until a maximal time}
\usage{
sim_path(i, rates, dists, t = 0, u = 0, tn = Inf, abs = numeric(0), bs = NA)
}
\arguments{
\item{i}{The initial state, integer.}

\item{rates}{The total transition rates out of states, a function with arguments state (integer), time (numeric), and duration (numeric) returning a rate (numeric).}

\item{dists}{The distribution of marks, a function with arguments state (integer), time (numeric), and duration (numeric) returning a probability vector.}

\item{t}{The initial time, numeric.}

\item{u}{The initial duration (since the last transition), numeric. By default equal to zero}

\item{tn}{The maximal time, numeric. By default equal to inifinity}

\item{abs}{Vector indicating which states are absorbing. By default the last state is absorbing.}

\item{bs}{Vector of upper bounds on the total transition rates. By default the bounds are determined using optimize, which might only identify a local maximum.}
}
\value{
A list concerning jump times and states, with the first time being the initial time t and state and the last time being tn (if not absorbed)
}
\description{
Simulate the path of a time-inhomogeneous (semi-)Markov process until a maximal time
}
\examples{

jump_rate <- function(i, t, u){if(i == 1){3*t} else if(i == 2){5*t} else{0}}
mark_dist <- function(i, s, v){if(i == 1){c(0, 1/3, 2/3)} else if(i == 2){c(1/5, 0, 4/5)} else{0}}
sim <- sim_path(sample(1:2, 1), t = 0, tn = 2, rates = jump_rate, dists = mark_dist)
sim
}
