% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/merge_results.r
\name{merge_gmt}
\alias{merge_gmt}
\title{Merge and filter GMT files based on a list of term IDs}
\usage{
merge_gmt(gmt_file, term_ids)
}
\arguments{
\item{gmt_file}{Path to the GMT file}

\item{term_ids}{Character vector of term IDs to include}
}
\value{
A GMT object containing only the specified terms
}
\description{
This function reads a GMT file and filters it to include only the specified term IDs.
It's useful for creating a filtered GMT file for visualization in Cytoscape.
}
\examples{
\dontrun{
# Get term IDs from merged results
merged_results <- merge_results(
  enriched_pathways, enriched_pathways_directional,
  gmt_file = fname_GMT2,
  output_prefix = "Aggregated",
  tests = c('rna', 'protein', 'combined'),
  col_colors = c("#FF0000", "#00FF00", "#FFFFF0")
)

# Merge and filter GMT file
merge_gmt(
  gmt_file = fname_GMT2,
  term_ids = merged_results$term_ids
)
}
}
