% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AcuityView.R
\name{AcuityView}
\alias{AcuityView}
\title{AcuityView}
\usage{
AcuityView(photo = NULL, distance = 2, realWidth = 2,
  eyeResolutionX = 0.2, eyeResolutionY = NULL, plot = T,
  output = "test.jpg")
}
\arguments{
\item{photo}{The photo you wish to alter; if NULL then a pop up window allows you to navigate to your photo, otherwise include the file path here}

\item{distance}{The distance from the viewer to the object of interest in the image; can be in any units so long as it is in the same units as RealWidth}

\item{realWidth}{The real width of the entire image; can be in any units as long as it is in the same units as distance}

\item{eyeResolutionX}{The resolution of the viewer in degrees}

\item{eyeResolutionY}{The resolution of the viewer in the Y direction, if different than ResolutionX; defaults to NULL, as it is uncommon for this to differ from eyeResolutionX}

\item{plot}{Whether to plot the final image; defaults to T, but if F, the final image will still be saved to your working directory}

\item{output}{The name of the output file, must be in the format of output="image_name.filetype"; acceptable filetypes are .bmp, .png, or .jpeg}
}
\value{
Returns an image in the specified format
}
\description{
This function provides a simple method for displaying a visual scene as it may appear to an animal with lower acuity.
}
\section{Image Format Requirements}{
 Image must be in 3-channel format, either PNG, JPEG or BMP. Note: some PNG files have an alpha channel that makes them 4-channel images; this will not work with the code. The image must be 3-channel.
}

\section{Image size}{
 Image must be square with each side a power of 2 pixels. Example: 512x512, 1024 x 1024, 2048 x 2048 pixels
}

\section{For Linux Users}{
 You may need to install the fftw library in order for the R package "fftwtools" to install and perform correctly. 
The FFTW website and install information can be found here: http://www.fftw.org/
This library can easily be installed on Ubuntu with: apt-get install fftw3-dev
}

\examples{
require(imager)
photo<-system.file('extdata/reef.bmp', package='AcuityView')
reef<-load.image(photo)
AcuityView(photo = reef, distance = 2, realWidth = 2, eyeResolutionX = 2,
eyeResolutionY = NULL, plot = TRUE, output="Example.jpeg")
}
