% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ma.R
\name{ma}
\alias{ma}
\title{Moving Average Calculator}
\usage{
ma(data, man = 10, warnings = FALSE)
}
\arguments{
\item{data}{A \code{numeric} vector (e.g. a \code{numeric} column of a \code{dataframe}).}

\item{man}{An \code{integer} value specifying the order of the moving average applied to the data. By default, \code{man = 10}.}

\item{warnings}{A \code{logical} value specifying the show of warning messages. By default, \code{warnings = FALSE}.}
}
\value{
This function returns a vector with the moving average of the input data.
}
\description{
Function to calculate the moving average of a given numeric vector. The order of the moving average may be customized by the user (\code{man} argument).
}
\examples{
data("munich_pollen")
ma(data = munich_pollen$Betula, man = 10, warnings = FALSE)
}
