% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.ai.R
\name{plot.ai}
\alias{plot.ai}
\title{plot.ai}
\usage{
\method{plot}{ai}(x, clin.limit = NA, which = 1:4, ...)
}
\arguments{
\item{x}{ai object from ai function}

\item{clin.limit}{Clinically meaningful lower and upper limit}

\item{which}{Index parameter to control which plot to output, by default, all four plots will be outputed.}

\item{...}{Additional arguments to be passed to the round function and to control number of decimals in the display.}
}
\value{
Function plot.ai returns 2 by 2 plots (See details)
}
\description{
The plot method for ai objects
}
\details{
The four plots include 1) scatterplot of raw data with regression line from the measurement error model,
2) Difference between two measurement methods with original average interval determined by alpha and clinically meaningful lower and upper limit,
3) Difference between two measurement methods  with average interval adjusted for fixed bias,
as well as 4) Sorted difference bewteen two measurement methods with average interval adjusted for total bias.
}
\examples{
a <- c(1, 2, 3, 4, 7)
b <- c(1, 3, 2, 5, 3)
ans <- ai(x=a, y=b)
plot(x=ans)
plot(x=ans, clin.limit=c(-5, 5))
}
\references{
Jason J. Z. Liao, Quantifying an Agreement Study, Int. J. Biostat. 2015; 11(1): 125-133
}
\author{
Jialin Xu, Jason Liao
}
