% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gompertz_analysis.R
\name{GP}
\alias{GP}
\title{Analysis: Gompertz}
\usage{
GP(
  trat,
  resp,
  npar = "g2",
  sample.curve = 1000,
  ylab = "Dependent",
  xlab = "Independent",
  theme = theme_classic(),
  legend.position = "top",
  r2 = "all",
  ic = FALSE,
  fill.ic = "gray70",
  alpha.ic = 0.5,
  error = "SE",
  point = "all",
  width.bar = NA,
  scale = "none",
  textsize = 12,
  pointsize = 4.5,
  linesize = 0.8,
  linetype = 1,
  pointshape = 21,
  fillshape = "gray",
  colorline = "black",
  round = NA,
  xname.formula = "x",
  yname.formula = "y",
  comment = NA,
  fontfamily = "sans",
  print.on = TRUE
)
}
\arguments{
\item{trat}{Numeric vector with dependent variable.}

\item{resp}{Numeric vector with independent variable.}

\item{npar}{Number os parameters (g2, g3 or g4)}

\item{sample.curve}{Provide the number of observations to simulate curvature (default is 1000)}

\item{ylab}{Variable response name (Accepts the \emph{expression}() function)}

\item{xlab}{treatments name (Accepts the \emph{expression}() function)}

\item{theme}{ggplot2 theme (\emph{default} is theme_bw())}

\item{legend.position}{legend position (\emph{default} is "top")}

\item{r2}{coefficient of determination of the mean or all values (\emph{default} is all)}

\item{ic}{Add interval of confidence}

\item{fill.ic}{Color interval of confidence}

\item{alpha.ic}{confidence interval transparency level}

\item{error}{Error bar (It can be SE - \emph{default}, SD or FALSE)}

\item{point}{defines whether you want to plot all points ("all") or only the mean ("mean")}

\item{width.bar}{Bar width}

\item{scale}{Sets x scale (\emph{default} is none, can be "log")}

\item{textsize}{Font size}

\item{pointsize}{shape size}

\item{linesize}{line size}

\item{linetype}{line type}

\item{pointshape}{format point (default is 21)}

\item{fillshape}{Fill shape}

\item{colorline}{Color lines}

\item{round}{round equation}

\item{xname.formula}{Name of x in the equation}

\item{yname.formula}{Name of y in the equation}

\item{comment}{Add text after equation}

\item{fontfamily}{Font family}

\item{print.on}{Print output}
}
\value{
The function returns a list containing the coefficients and their respective values of p; statistical parameters such as AIC, BIC, pseudo-R2, RMSE (root mean square error); largest and smallest estimated value and the graph using ggplot2 with the equation automatically.
}
\description{
The logistical models provide Gompertz modified logistical models. This model was extracted from the 'drc' package.
}
\details{
The two-parameter Gompertz model is given by the function:
\deqn{y = exp^{-exp^{b(x-e)}}}
The three-parameter Gompertz model is given by the function:
\deqn{y = d \times exp^{-exp^{b(x-e)}}}
The four-parameter Gompertz model is given by the function:
\deqn{y = c + (d-c)(exp^{-exp^{b(x-e)}})}
}
\examples{
library(AgroReg)
data("aristolochia")
attach(aristolochia)
GP(trat,resp, npar="g3")
}
\references{
Seber, G. A. F. and Wild, C. J (1989) Nonlinear Regression, New York: Wiley and Sons (p. 330).

Ritz, C.; Strebig, J.C. and Ritz, M.C. Package ‘drc’. Creative Commons: Mountain View, CA, USA, 2016.
}
\seealso{
\link{LL}, \link{CD}, \link{BC}
}
\author{
Model imported from the drc package (Ritz et al., 2016)

Gabriel Danilo Shimizu

Leandro Simoes Azeredo Goncalves
}
