% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bitmapfont.r
\name{read.AmigaBitmapFontSet}
\alias{read.AmigaBitmapFontSet}
\title{Read AmigaBitmapFontSet from *.font file}
\usage{
read.AmigaBitmapFontSet(file, ...)
}
\arguments{
\item{file}{A \code{character} string of the filename of the *.font file to be read.}

\item{...}{Currently ignored.}
}
\value{
Returns an \code{\link[=AmigaBitmapFontSet]{AmigaBitmapFontSet()}} object read from the specified file.
}
\description{
Reads \code{\link[=AmigaBitmapFontSet]{AmigaBitmapFontSet()}} from *.font file including
all nested bitmap images for all font heights.
}
\details{
The *.font file only holds meta-information. The bitmap images for
each font height are stored in separate files, which are listed
in the *.font file. The function reads the *.font file, including
all nested bitmap files and returns it as a
\code{\link[=AmigaBitmapFontSet]{AmigaBitmapFontSet()}}.

It can also read *.font files
from virtual disks ((\code{\link[adfExplorer:adf_file_con]{adf_file_con()}})) objects,
but that requires the adfExplorer package to be installed.
}
\examples{
data(font_example)

## in order to read, we first need to write a file"
write.AmigaBitmapFontSet(font_example, tempdir())

## The font is written as 'AmigaFFH.font' as that name
## is embedded in the AmigaBitmapFontSet object 'font_example'.
## We can read it as follows:
font.read <- read.AmigaBitmapFontSet(file.path(tempdir(), "AmigaFFH.font"))

## similarly, the file can also be written and read from and to
## a virtual amiga disk. The following codes requires the 'adfExplorer'
## package:
if (requireNamespace("adfExplorer")) {
  library("adfExplorer")
  virtual_disk_file <- tempfile(fileext = ".adf") |>
    create_adf_device(write_protected = FALSE) |>
    prepare_adf_device("font_disk") |>
    make_adf_dir("FONTS")
  
  dest <- virtual_path(virtual_disk_file, "DF0:FONTS")
  write.AmigaBitmapFontSet(font_example, dest)
  font.read <- read.AmigaBitmapFontSet(
    virtual_path(virtual_disk_file, "DF0:FONTS/AmigaFFH.font")
  )
  close(virtual_disk_file)
}
}
\seealso{
Other AmigaBitmapFont.operations: 
\code{\link{AmigaBitmapFont}},
\code{\link{availableFontSizes}()},
\code{\link{c}()},
\code{\link{fontName}()},
\code{\link{font_example}},
\code{\link{getAmigaBitmapFont}()},
\code{\link{rasterToAmigaBitmapFont}()},
\code{\link{rawToAmigaBitmapFont}()},
\code{\link{rawToAmigaBitmapFontSet}()},
\code{\link{read.AmigaBitmapFont}()},
\code{\link{write.AmigaBitmapFont}()}

Other io.operations: 
\code{\link{read.AmigaBasic}()},
\code{\link{read.AmigaBasicBMAP}()},
\code{\link{read.AmigaBasicShape}()},
\code{\link{read.AmigaBitmapFont}()},
\code{\link{read.AmigaIcon}()},
\code{\link{read.SysConfig}()},
\code{\link{read.iff}()},
\code{\link{write.AmigaBasic}()},
\code{\link{write.AmigaBasicShape}()},
\code{\link{write.AmigaBitmapFont}()},
\code{\link{write.AmigaIcon}()},
\code{\link{write.SysConfig}()},
\code{\link{write.iff}()}
}
\author{
Pepijn de Vries
}
\concept{AmigaBitmapFont.operations}
\concept{io.operations}
