% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_AMPs.R
\name{get_AMPs}
\alias{get_AMPs}
\title{Get putative antimicrobial peptides}
\usage{
get_AMPs(x)
}
\arguments{
\item{x}{AmpGram predictions for a single protein}
}
\value{
a data.frame with sequences recognized as antimicrobial peptides (AMPs). 
It consists of two columns:
\describe{
  \item{putative_AMP}{amino acid sequence of a 10-mer (subsequence of an analyzed peptide)
  predicted as AMP.}
  \item{prob}{Probability with which a 10-mer is recognized as AMP.}}
}
\description{
Function gets sequences recognized as antimicrobial peptides and returns as data.frame.
}
\examples{
data(AmpGram_predictions)
get_AMPs(AmpGram_predictions[[2]])
}
