% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genomeObject.R
\name{addObservedSynthesisRateSet}
\alias{addObservedSynthesisRateSet}
\title{Add gene observed synthesis rates}
\usage{
addObservedSynthesisRateSet(
  genome,
  observed.expression.file,
  match.expression.by.id = TRUE
)
}
\arguments{
\item{genome}{A genome object initialized with 
\code{\link{initializeGenomeObject}} to add observed expression data.}

\item{observed.expression.file}{A string containing 
the location of a file containing empirical expression rates (optional).}

\item{match.expression.by.id}{If TRUE (default) observed expression 
values will be assigned by matching sequence identifier.
If FALSE observed expression values will be assigned by order}
}
\value{
Returns the genome after adding the new gene expression values
}
\description{
\code{addObservedSynthesisRateSet} returns the observed 
synthesis rates of the genes within the genome specified.
}
\examples{

genome_file <- system.file("extdata", "genome.fasta", package = "AnaCoDa")
expression_file <- system.file("extdata", "expression.csv", package = "AnaCoDa") 
## reading genome
genome <- initializeGenomeObject(file = genome_file)


## add expression values after the genome was initiallized, 
## or adding an additional set of expression values
genome <- addObservedSynthesisRateSet(genome = genome, 
                   observed.expression.file = expression_file)

}
