% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genomeObject.R
\name{getObservedSynthesisRateSet}
\alias{getObservedSynthesisRateSet}
\title{Get gene observed synthesis rates}
\usage{
getObservedSynthesisRateSet(genome, simulated = FALSE)
}
\arguments{
\item{genome}{A genome object initialized with \code{\link{initializeGenomeObject}}.}

\item{simulated}{A logical value denoting if the synthesis 
rates to be listed are simulated or not. The default value is FALSE.}
}
\value{
Returns a data.frame with the observed expression values in genome
}
\description{
\code{getObservedSynthesisRateSet} returns the observed 
synthesis rates of the genes within the genome specified.
}
\examples{

genome_file <- system.file("extdata", "genome.fasta", package = "AnaCoDa")
expression_file <- system.file("extdata", "expression.csv", package = "AnaCoDa") 
## reading genome
genome <- initializeGenomeObject(file = genome_file)


## return expression values as a data.frame with gene ids in the first column.
expressionValues <- getObservedSynthesisRateSet(genome = genome)

}
