% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/storage_tables.R
\name{storage_table}
\alias{storage_table}
\alias{storage_table.table_endpoint}
\alias{list_storage_tables}
\alias{list_storage_tables.table_endpoint}
\alias{create_storage_table}
\alias{create_storage_table.table_endpoint}
\alias{create_storage_table.storage_table}
\alias{delete_storage_table}
\alias{delete_storage_table.table_endpoint}
\alias{delete_storage_table.storage_table}
\title{Operations with azure tables}
\usage{
storage_table(endpoint, ...)

\method{storage_table}{table_endpoint}(endpoint, name, ...)

list_storage_tables(endpoint, ...)

\method{list_storage_tables}{table_endpoint}(endpoint, ...)

create_storage_table(endpoint, ...)

\method{create_storage_table}{table_endpoint}(endpoint, name, ...)

\method{create_storage_table}{storage_table}(endpoint, ...)

delete_storage_table(endpoint, ...)

\method{delete_storage_table}{table_endpoint}(endpoint, name, confirm = TRUE, ...)

\method{delete_storage_table}{storage_table}(endpoint, ...)
}
\arguments{
\item{endpoint}{An object of class \code{table_endpoint} or, for \code{create_storage_table.storage_table}, an object of class \code{storage_table}.}

\item{...}{Other arguments passed to lower-level functions.}

\item{name}{The name of a table in a storage account.}

\item{confirm}{For deleting a table, whether to ask for confirmation.}
}
\value{
\code{storage_table} and \code{create_storage_table} return an object of class \code{storage_table}. \code{list_storage_tables} returns a list of such objects.
}
\description{
Operations with azure tables
}
\details{
These methods are for accessing and managing tables within a storage account.
}
\examples{
\dontrun{

endp <- table_endpoint("https://mystorageacct.table.core.windows.net", key="mykey")

create_storage_table(endp, "mytable")
tab <- storage_table(endp, "mytable2")
create_storage_table(tab)
list_storage_tables(endp)
delete_storage_table(tab)
delete_storage_table(endp, "mytable")

}
}
\seealso{
\link{table_endpoint}, \link{table_entity}
}
