% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getBeIdConvTable.R
\name{getBeIdConvTable}
\alias{getBeIdConvTable}
\title{Get a conversion table between biological entity (BE) identifiers}
\usage{
getBeIdConvTable(
  from,
  to = from,
  from.source,
  to.source,
  organism,
  caseSensitive = FALSE,
  canonical = FALSE,
  restricted = TRUE,
  entity = TRUE,
  verbose = FALSE,
  recache = FALSE,
  filter = NULL,
  limForCache = 100
)
}
\arguments{
\item{from}{one BE or "Probe"}

\item{to}{one BE or "Probe"}

\item{from.source}{the from BE ID database if BE or
the from probe platform if Probe}

\item{to.source}{the to BE ID database if BE or
the to probe platform if Probe}

\item{organism}{organism name}

\item{caseSensitive}{if TRUE the case of provided symbols
is taken into account
during the conversion and selection.
This option will only affect the conversion from "Symbol"
(default: caseSensitive=FALSE).
All the other conversion will be case sensitive.}

\item{canonical}{if TRUE, only returns the canonical "Symbol".
(default: FALSE)}

\item{restricted}{boolean indicating if the results should be restricted to
current version of to BEID db. If FALSE former BEID are also returned:
\strong{Depending on history it can take a very long time to return
a very large result!}}

\item{entity}{boolean indicating if the technical ID of to BE should be
returned}

\item{verbose}{boolean indicating if the CQL query should be displayed}

\item{recache}{boolean indicating if the CQL query should be run even if
the table is already in cache}

\item{filter}{character vector on which to filter from IDs.
If NULL (default), the result is not filtered:
all from IDs are taken into account.}

\item{limForCache}{if there are more filter than limForCache results are
collected for all IDs (beyond provided ids) and cached for futur queries.
If not, results are collected only for provided ids and not cached.}
}
\value{
a data.frame mapping BE IDs with the
following fields:
\itemize{
\item \strong{from}: the from BE ID
\item \strong{to}: the to BE ID
\item \strong{entity}: (optional) the technical ID of to BE
\item \strong{preferred}: true if "to" is the preferred identifier for the entity
}
}
\description{
Get a conversion table between biological entity (BE) identifiers
}
\examples{
\dontrun{
getBeIdConvTable(
    from="Gene", from.source="EntrezGene",
    to.source="Ens_gene",
    organism="human"
)
}

}
\seealso{
\link{getHomTable}, \link{listBe}, \link{listPlatforms}, \link{listBeIdSources}
}
