% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FINAL_FUNCTIONS_f_test.R
\name{f_test_BFF}
\alias{f_test_BFF}
\title{f_test_BFF}
\usage{
f_test_BFF(
  f_stat,
  n,
  df1,
  df2,
  omega = NULL,
  omega_sequence = if (is.null(omega)) seq(0.01, 1, by = 0.01),
  r = 1
)
}
\arguments{
\item{f_stat}{T statistic}

\item{n}{sample size (if one sample test)}

\item{df1}{sample size of group one for two sample test.}

\item{df2}{sample size of group two for two sample test}

\item{omega}{standardized effect size. For the f-test, this is often called Cohen's f (can be a single entry or a vector of values)}

\item{omega_sequence}{sequence of standardized effect sizes. If no omega is provided, omega_sequence is set to be seq(0.01, 1, by = 0.01)}

\item{r}{variable controlling dispersion of non-local priors. Default is 1. r must be >= 1}
}
\value{
Returns an S3 object of class `BFF` (see `BFF.object` for details).
}
\description{
f_test_BFF constructs BFFs based on the t test. BFFs depend on hyperparameters r and tau^2 which determine the shape and scale of the prior distributions which define the alternative hypotheses.
By setting r > 1, we use higher-order moments for replicated studies. Fractional moments are set with r > 1 and r not an integer.
All results are on the log scale.
}
\examples{
fBFF = f_test_BFF(f_stat = 1.5, n = 50, df1 = 25, df2 = 48)
fBFF
plot(fBFF)

}
