% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FINAL_FUNCTIONS_t_test.R
\name{t_test_BFF}
\alias{t_test_BFF}
\title{t_test_BFF}
\usage{
t_test_BFF(
  t_stat,
  n = NULL,
  n1 = NULL,
  n2 = NULL,
  one_sample = FALSE,
  alternative = "two.sided",
  omega = NULL,
  omega_sequence = if (is.null(omega)) seq(0.01, 1, by = 0.01),
  r = 1
)
}
\arguments{
\item{t_stat}{t statistic}

\item{n}{sample size (if one sample test)}

\item{n1}{sample size of group one for two sample test. Must be provided if one_sample = FALSE}

\item{n2}{sample size of group two for two sample test. Must be provided if one_sample = FALSE}

\item{one_sample}{is test one sided? Default is FALSE}

\item{alternative}{the alternative. options are "two.sided" or "less" or "greater"}

\item{omega}{standardized effect size. For the t-test, this is often called Cohen's d (can be a single entry or a vector of values)}

\item{omega_sequence}{sequence of standardized effect sizes. If no omega is provided, omega_sequence is set to be seq(0.01, 1, by = 0.01)}

\item{r}{variable controlling dispersion of non-local priors. Default is 1. r must be >= 1}
}
\value{
Returns an S3 object of class `BFF` (see `BFF.object` for details).
}
\description{
t_test_BFF constructs BFFs based on the t test. BFFs depend on hyperparameters r and tau^2 which determine the shape and scale of the prior distributions which define the alternative hypotheses.
By setting r > 1, we use higher-order moments for replicated studies. Fractional moments are set with r > 1 and r not an integer.
All results are on the log scale.
}
\examples{
tBFF = t_test_BFF(t_stat = 2.5, n = 50, one_sample = TRUE)
tBFF
plot(tBFF)
}
