% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/observ_powerexp.R
\name{observ_powerexp}
\alias{observ_powerexp}
\title{Example of distribution of views -- power exponential distribution}
\usage{
observ_powerexp(x, q, covmat, beta = 0.6)
}
\arguments{
\item{x}{Data points matrix which collects in rows coordinates of points in which distribution density is  computed.}

\item{q}{Vector of investor's views.}

\item{covmat}{Covariance matrix of the distribution; dispersion matrix \eqn{\Sigma} is computed from \code{covmat}.}

\item{beta}{Shape parameter of the power exponential distribution.}
}
\value{
function returns a vector of distribution densities in data points x.
}
\description{
Function observ_powerexp computes density of power exponential distribution of views   using the formula\cr
\eqn{f(x) = c_k*\exp(- ((x-q)^{T}*\Sigma^{-1}*(x-q))^{\beta}/2)},\cr
where \eqn{c_k} is a normalization constant (depends on the dimension of \eqn{x} and \eqn{q}) and \eqn{\Sigma} is the dispersion matrix.
}
\examples{
k =3
observ_powerexp (x = matrix(c(rep(0.5,k),rep(0.2,k)),k,2), q = matrix(0,k,1),
               covmat = diag(k), beta = 0.6)

}
\references{
Gomez, E., Gomez-Villegas, M., Marin, J.,  A multivariate generalization of the power exponential family of distributions. Commun. Statist. Theory Methods, 27 (1998), 589--600.
DOI: 10.1080/03610929808832115
}
