% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/imputeCML.R
\encoding{UTF-8}
\name{imputeCML}
\alias{imputeCML}
\title{imputing BLOQ's using censored maximum likelihood}
\usage{
imputeCML(
  inputData,
  LOQ,
  isMultiplicative = FALSE,
  useSeed = runif(1),
  printCMLmessage = TRUE,
  CMLcontrol = NULL
)
}
\arguments{
\item{inputData}{numeric matrix or data frame of the size 
n by J (n the sample size and J the number of time points)
 the input dataset}

\item{LOQ}{scalar, limit of quantification value}

\item{isMultiplicative}{logical variable indicating whether
an additive error model (FALSE) or a multiplicative error
model (TRUE) should be used}

\item{useSeed}{scalar, set a seed to make the results 
reproducible, default is runif(1), it is used to randomly 
order the first imputed column (if the first column has any BLOQ's)}

\item{printCMLmessage}{logical variable with TRUE as default, if TRUE then
messages regarding the convergence status of censored 
log-likelihood maximization will be printed.}

\item{CMLcontrol}{list of arguments to control 
convergence of maximization algorithm. It is the same argument
as control in the function maxLik in the R package maxLik}
}
\value{
the imputed dataset: a numeric matrix or data frame of the size 
n by J (n the sample size and J the number of time points)
}
\description{
function to impute BLOQ's using quantiles of a normal 
distribution with mean and standard error estimates using 
censored maximum likelihood
}
\examples{
# generate data from Beal model with only fixed effects
set.seed(111)
genDataFixedEffects <- simulateBealModelFixedEffects(10, 0.693,
+ 		1, 1, seq(0.5,3,0.5))
imputeCML(genDataFixedEffects, 0.1, FALSE, 1)
}
\seealso{
\href{https://www.rdocumentation.org/packages/maxLik/versions/1.3-4/topics/maxLik}{maxLik}
}
\author{
Vahid Nassiri, Helen Yvette Barnett
}
