% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/concoreg.R
\name{concoreg}
\alias{concoreg}
\title{Redundancy of sets yj by one set x}
\usage{
concoreg(x, y, py, r)
}
\arguments{
\item{x}{are the \code{n} times \code{p} and \code{n} times \code{q} matrices of \code{p} and \code{q} centered column}

\item{y}{See \code{x}}

\item{py}{The partition vector of y. A row vector containing the numbers \code{qi} for \code{i = 1,...,ky} of the \code{ky} subsets \code{yi} of \code{y : sum(qi)=sum(py)=q}.}

\item{r}{The number of wanted successive solutions}
}
\value{
A \code{list} with following components:
\item{cx}{a \code{n} times \code{r}matrix of the r explanatory components}
\item{v}{is a \eqn{q \times r}{q x r} matrix of ky row blocks \eqn{v_i} (\eqn{q_i \times r}{q_i x r}) of axes in Rqi relative to yi; \eqn{v_i'*v_i = \mbox{Id}}}
\item{V}{is a \eqn{q \times r}{q x r} matrix of axes in Rq relative to y; \eqn{V'*V = \mbox{Id}}}
\item{varexp}{is a \eqn{ky \times r}{ky x r} matrix; each column k contains ky explained variances \eqn{\rho(cx[,k],y_i*v_i[,k])^2 \mbox{var}(y_i*v_i[,k])}}
}
\description{
Regression of several subsets of variables Yj by another set X. SUCCESSIVE SOLUTIONS
}
\examples{
x <- matrix(runif(50),10,5);y <- matrix(runif(90),10,9)
x <- scale(x);y <- scale(y)
co <- concoreg(x,y,c(3,2,4),2)

}
\references{
Lafosse R. & Hanafi M.(1997) Concordance d'un tableau avec K tableaux: Definition de K+1 uples synthetiques. Revue de Statistique Appliquee vol.45,n.4.

Chessel D. & Hanafi M. (1996) Analyses de la Co-inertie de K nuages de points.  Revue de Statistique Appliquee vol.44, n.2. (this ACOM analysis of one multiset is obtained by the command : concoreg(Y,Y,py,r))
}
\author{
\enc{Lafosse, R.}{R. Lafosse}
}
