\name{tseriescm}
\alias{tseriescm}
\title{
Function for monthly time series clustering. 
}
\description{
Function that performs the time series clustering algorithm described in Nieto-Barajas and Contreras-Cristan (2014) for monthly time series data.
}
\usage{
tseriescm(data, maxiter = 500, burnin = floor(0.1 * maxiter), 
          thinning = 5, scale = TRUE, level = FALSE, trend = TRUE, seasonality = TRUE,
          deg = 2, c0eps = 2, c1eps = 1, c0beta = 2, c1beta = 1, c0alpha = 2, 
          c1alpha = 1, priora = TRUE, pia = 0.5, q0a = 1, q1a = 1, priorb = TRUE, 
          q0b = 1, q1b = 1, a = 0.25, b = 0, indlpml = FALSE)
}
\arguments{
  \item{data}{
Data frame with the time series information. 
}
  \item{maxiter}{
Maximum number of iterations for Gibbs sampling.
}
  \item{burnin}{
Burn-in period of the Markov Chain generated by Gibbs sampling. 
}
  \item{thinning}{
Number that indicates how many Gibbs sampling simulations should be skipped to form the Markov Chain.
}
  \item{scale}{
Flag that indicates if the time series data should be scaled to the [0,1] interval with a linear transformation as proposed by Nieto-Barajas and Contreras-Cristan (2014). If TRUE, then the time series are scaled to the [0,1] interval. 
}
  \item{level}{
Flag that indicates if the level of the time series will be considered for clustering. If TRUE, then it is taken into account.
}
  \item{trend}{
Flag that indicates if the polinomial trend of the model will be considered for clustering. If TRUE, then it is taken into account. 
}
  \item{seasonality}{Flag that indicates if the seasonal components of the model will be considered for clustering. If TRUE, then they are taken into account.
}
  \item{deg}{
Degree of the polinomial trend of the model.
}
  \item{c0eps}{
Shape parameter of the hyper-prior distribution on sig2eps.
}
  \item{c1eps}{
Rate parameter of the hyper-prior distribution on sig2eps. 
}
  \item{c0beta}{
Shape parameter of the hyper-prior distribution on sig2beta. 
}
  \item{c1beta}{
Rate parameter of the hyper-prior distribution on sig2beta. 
}
  \item{c0alpha}{
Shape parameter of the hyper-prior distribution on sig2alpha. 
}
  \item{c1alpha}{
Rate parameter of the hyper-prior distribution on sig2alpha. 
}
  \item{priora}{
Flag that indicates if a prior on parameter "a" is to be assigned. If TRUE, a prior on "a" is assigned.           
}
  \item{pia}{
Mixing proportion of the prior distribution on parameter "a".
}
  \item{q0a}{
Shape parameter of the continuous part of the prior distribution on parameter "a". 
}
  \item{q1a}{
Shape parameter of the continuous part of the prior distribution on parameter "a".
}
  \item{priorb}{
Flag that indicates if a prior on parameter "b" is to be assigned. If TRUE, a prior on "b" is assigned.
}
  \item{q0b}{
Shape parameter of the prior distribution on parameter "b". 
}
  \item{q1b}{
Shape parameter of the prior distribution on parameter "b". 
}
  \item{a}{
Initial/fixed value of parameter "a".
}
  \item{b}{
Initial/fixed value of parameter "b".
}
  \item{indlpml}{
Flag that indicates if the LPML is to be calculated. If TRUE, LPML is calculated.  
}
}
\details{
It is assumed that the time series data is organized into a data frame with the time periods included as its row names. 
}
\value{
\item{mstar}{Number of groups of the chosen cluster configuration.}
\item{gnstar}{Array that contains the group number to which each time series belongs.}
\item{HM}{Heterogeneity Measure of the chosen cluster configuration.} 
\item{arrho}{Acceptance rate of the parameter "rho".}
\item{ara}{Acceptance rate of the parameter "a".}
\item{arb}{Acceptance rate of the parameter "b".}
\item{sig2epssample}{Matrix that in its columns contains the sample of each sig2eps_i's posterior distribution after Gibbs sampling.}
\item{sig2alphasample}{Matrix that in its columns contains the sample of each sig2alpha_i's posterior distribution after Gibbs sampling.}
\item{sig2betasample}{Matrix that in its columns contains the sample of each sig2beta_i's posterior distribution after Gibbs sampling.}
\item{sig2thesample}{Vector that contains the sample of sig2the's posterior distribution after Gibbs sampling.} 
\item{rhosample}{Vector that contains the sample of rho's posterior distribution after Gibbs sampling.}
\item{asample}{Vector that contains the sample of a's posterior distribution after Gibbs sampling.}
\item{bsample}{Vector that contains the sample of b's posterior distribution after Gibbs sampling.}
\item{msample}{Vector that contains the sample of the number of groups at each Gibbs sampling iteration.}
\item{lpml}{If indlpml = TRUE, lpml contains the value of the LPML of the chosen model.}
\item{scale}{Flag that indicates if the time series data were scaled to the [0,1] interval with a linear transformation. This will be taken as an input for the plotting functions.}
}
\author{
Martell-Juarez, D.A. and Nieto-Barajas, L.E.
}
\examples{
## Do not run
#
# data(stocks)
# tseriescm.out <- tseriescm(stocks,maxiter=4000,level=FALSE,trend=TRUE,
#                            seasonality=TRUE,priorb=FALSE,b=0)
#
# Make sure that chain convergence is always assessed. Run the following 
# code to show the cluster and diagnostic plots:

data(stocks)
data(tseriescm.out)
attach(tseriescm.out)

clusterplots(tseriescm.out,stocks)
diagplots(tseriescm.out)
}